package com.bcxin.tenant.domain.services.commands;

import cn.hutool.core.util.IdcardUtil;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.Infrastructures.validations.CredentialValidator;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.readers.dtos.BatchEmployeeValidationDto;
import com.bcxin.tenant.domain.configs.TenantUserConfig;
import lombok.Getter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.persistence.Embedded;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@Getter
public class BackEmployeeCommand extends CommandAbstract {
    private final String id;
    private final String organizationId;
    private final String departId;
    private final OccupationType occupationType;
    private Date hiredDate;

    @Embedded
    private final OperatorValueType operator;

    public BackEmployeeCommand(String id, String organizationId,
                               String departId,
                               OccupationType occupationType,
                               Date hiredDate,
                               OperatorValueType operator) {
        this.id = id;
        this.organizationId = organizationId;
        this.departId = departId;
        this.occupationType = occupationType;
        this.hiredDate = hiredDate;
        this.operator = operator;
    }

    public static BackEmployeeCommand create(String id, String organizationId,
                                             String departId,
                                             OccupationType occupationType,
                                             Date hiredDate,
                                             OperatorValueType operator) {
        return new BackEmployeeCommand(id, organizationId, departId, occupationType, hiredDate,operator);
    }

    public void setHiredDate(Date hiredDate){
        this.hiredDate = hiredDate;
    }

    @Override
    public void validate() {
        validate(null);
    }

    public void validate(TenantUserConfig tenantUserConfig) {
        super.validate();

        if (!StringUtils.hasLength(this.getId())) {
            throw new BadTenantException("职员id不能为空");
        }

        if (!StringUtils.hasLength(this.getOrganizationId())) {
            throw new BadTenantException("组织id不能为空");
        }

        if (!StringUtils.hasLength(this.getDepartId())) {
            throw new BadTenantException("部门id不能为空");
        }

        if (this.getOccupationType() == null) {
            throw new BadTenantException("职业类型不能为空");
        }

        if (this.getHiredDate() == null) {
            throw new BadTenantException("入职日期不能为空");
        }
        // 根据配置判断是否需要校验入职日期必须是当天
        if (tenantUserConfig != null && tenantUserConfig.isHiredDateMustBeToday() 
            && !DateUtil.format2ShortDate().equals(DateUtil.format2ShortDate(this.getHiredDate()))) {
            throw new ArgumentTenantException("入职日期必须是当天");
        }
    }
}
