package com.bcxin.tenant.domain.repositories.dtos;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.util.DateUtils;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.*;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;

@Data
public class EmployeeExportDto implements Serializable {

    private static final long serialVersionUID = 4530474987109938356L;

    @ExcelIgnore
    @ExcelProperty("序号")
    private int index;
    //姓名
    @ExcelProperty("姓名")
    private String name;
    //手机号码
    @ExcelProperty("手机号码")
    private String telephone;

    @ExcelProperty("证件类型")
    private String credentialTypeName;
    //证件类型
    @ExcelIgnore
    private CredentialType credentialType;
    //证件号码、
    @ExcelProperty("证件号码")
    private String number;
    // 证件核验状态、
    @ExcelProperty("证件核验状态")
    private String checkedStatusName;
    @Enumerated(EnumType.ORDINAL)
    @ExcelIgnore
    private UserCheckedStatus checkedStatus;

    @ExcelProperty("核验时间")
    private String lastCheckedStatusTime;
    // 实名认证状态
    @ExcelProperty("实名认证状态")
    private String authenticateStatusName;
    @Enumerated(EnumType.ORDINAL)
    @ExcelIgnore
    private RealNameAuthenticatedStatus authenticateStatus;
    //认证失败原因
    @ExcelProperty("认证失败原因")
    private String authenticatedResult;
    //年龄
    @ExcelProperty("年龄")
    private Integer age;
    // 所属部门、
    @ExcelProperty("所属部门")
    private String departName;
    // 职业类型、
    @ExcelProperty("职业类型")
    private String occupationTypeName;

    @Enumerated(EnumType.ORDINAL)
    @ExcelIgnore
    private OccupationType occupationType;
    // 上级、
    @ExcelProperty("上级")
    private String superiorName;
    // 岗位、
    @ExcelProperty("岗位")
    private String position;
    // 入职时间、
    @ExcelProperty("入职时间")
    private String hiredDate;
    // 转正日期、
    @ExcelProperty("转正日期")
    private String positiveDate;
    // 司龄、
    @ExcelProperty("司龄(天)")
    private long workDays;
    // 性别、
    @ExcelProperty("性别")
    private String sexName;

    @Enumerated(EnumType.ORDINAL)
    @ExcelIgnore
    private Sex sex;
    // 出生日期、
    @ExcelProperty("出生日期")
    private String birthdate;
    // 民族、
    @ExcelProperty("民族")
    private String nation;
    // 文化程度、
    @ExcelProperty("文化程度")
    private String education;
    // 政治面貌、
    @ExcelProperty("政治面貌")
    private String politicsStatus;
    // 户籍类型、
    @ExcelProperty("户籍类型")
    private String householdType;
    // 身高、
    @ExcelProperty("身高")
    private String stature;
    // 籍贯、
    @ExcelProperty("籍贯")
    private String nativePlace;
    // 兵役情况、
    @ExcelProperty("兵役情况")
    private String militaryStatus;
    // 婚姻状况、
    @ExcelProperty("婚姻状况")
    private String maritalStatus;
    // 身份证有效期、
    @ExcelProperty("身份证有效期")
    private String validDate;
    @ExcelIgnore
    private Date validDateFrom;
    @ExcelIgnore
    private Date validDateTo;
    // 身份证住址、
    @ExcelProperty("身份证住址")
    private String address;
    // 是否签订合同（至少有一条有效状态的合同信息）、
    @ExcelProperty("是否签订合同")
    private String contractStatusName;
    @ExcelIgnore
    private TrueFalseStatus contractStatus;
    // 是否有保安资格证（至少有一条保安员资格证信息）、
    @ExcelProperty("是否有保安资格证")
    private String cerStatusName;
    @ExcelIgnore
    private TrueFalseStatus cerStatus;
    @ExcelIgnore
    private TrueFalseStatus gradeCerStatus;
    // 保安资格证号、
    @ExcelProperty("保安资格证号")
    private String cerNo;
    // 是否有等级证 、
    @ExcelProperty("是否有等级证")
    private String gradeCerStatusName;
    @ExcelProperty("等级证等级")
    private String gradeLevel;
    @ExcelProperty("等级证编号")
    private String gradeCerNo;
    // 是否投保（至少有一条生效的保单信息）、
    @ExcelProperty("是否投保")
    private String insureStatus;
    @ExcelIgnore
    private TrueFalseStatus insure;
    // 录入系统时间（用户创建时间）、
    @ExcelProperty("入驻系统时间")
    private String createdTime;
    // 是否为组织管理员、
    @ExcelProperty("是否为组织管理员")
    private String domainAdminStatus;

    @ExcelIgnore
    private TrueFalseStatus domainAdmin;
    // 是否为部门管理员、
    @ExcelProperty("是否为部门管理员")
    private String deparAdminStatus;
    @ExcelIgnore
    private TrueFalseStatus deparAdmin;
    // 可管理部门
    @ExcelProperty("可管理部门")
    private String manageDeparts;

//    员工状态、试用期、原定转正日期、紧急联系人姓名、紧急联系人电话、驾照等级、现住地址。
    /**
     * 员工状态（选填，单选：全职/兼职/试用/实习）
     */
    @ExcelProperty("员工状态")
    private String personStatusName;
    @ExcelIgnore
    private PersonStatus personStatus;

    /**
     * 试用期 数字
     */
    @ExcelProperty("试用期")
    private String probation;

    @ExcelProperty("原定转正日期")
    private String planPositiveDate;
    /**
     * 紧急联系人
     */
    @ExcelProperty("紧急联系人姓名")
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    @ExcelProperty("紧急联系人电话")
    private String emergencyPhone;

    /**
     * 驾照等级
     */
    @ExcelProperty("驾照等级")
    private String licenseLevel;

    @ExcelProperty("现住地址")
    private String placeOfNowName;
    @ExcelIgnore
    private LocationValueType placeOfNow;

    @Embedded
    private OperatorValueType hiredOperator;

    @ExcelProperty("操作人")
    private String hiredOperatorName;

    @ExcelProperty("操作时间")
    private String hiredOperatorDate;

    public EmployeeExportDto(
            int index,
            String name,
            String telephone,
            CredentialType credentialType,
            String number,
            UserCheckedStatus checkedStatus,
            String lastCheckedStatusTime,
            RealNameAuthenticatedStatus authenticateStatus,
            String authenticatedResult,
            String departName,
            OccupationType occupationType,
            String superiorName,
            String position,
            String hiredDate,
            String positiveDate,
            Sex sex,
            String birthdate,
            String nation,
            String education,
            String politicsStatus,
            String householdType,
            String stature,
            String nativePlace,
            String militaryStatus,
            String maritalStatus,
            Date validDateFrom,
            Date validDateTo,
            String address,
            TrueFalseStatus contractStatus,
            TrueFalseStatus cerStatus,
            TrueFalseStatus gradeCerStatus,
            String cerNo,
            String gradeLevel,
            String gradeCerNo,
            TrueFalseStatus insure,
            String createdTime,
            TrueFalseStatus domainAdmin,
            TrueFalseStatus deparAdmin,
            String manageDeparts,
            PersonStatus personStatus,
            String probation,
            String planPositiveDate,
            String emergencyContact,
            String emergencyPhone,
            String licenseLevel,
            LocationValueType placeOfNow,
            OperatorValueType hiredOperator
    ) {
        this.index = index;
        this.name = name;
        this.telephone = telephone;
        this.credentialType = credentialType;
        this.number = number;
        this.checkedStatus = checkedStatus;
        this.lastCheckedStatusTime = lastCheckedStatusTime;
        this.authenticateStatus = authenticateStatus;
        this.authenticatedResult = authenticatedResult;
        this.departName = departName;
        this.occupationType = occupationType;
        this.superiorName = superiorName;
        this.position = position;
        this.hiredDate = hiredDate;
        this.positiveDate = positiveDate;
        this.sex = sex;
        this.birthdate = birthdate;

        if(StrUtil.isNotEmpty(birthdate)) {
            try {
                this.age = DateUtil.ageOfNow(DateUtils.parseDate(birthdate));
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }

        this.nation = nation;
        this.education = education;
        this.politicsStatus = politicsStatus;
        this.householdType = householdType;
        this.stature = stature;
        this.nativePlace = nativePlace;
        this.militaryStatus = militaryStatus;
        this.maritalStatus = maritalStatus;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.address = address;
        this.contractStatus = contractStatus;
        this.cerStatus = cerStatus;
        this.gradeCerStatus = gradeCerStatus;
        this.cerNo = cerNo;
        this.gradeLevel = gradeLevel;
        this.gradeCerNo = gradeCerNo;
        this.insure = insure;
        this.createdTime = createdTime;
        this.domainAdmin = domainAdmin;
        this.deparAdmin = deparAdmin;
        this.manageDeparts = manageDeparts;
        this.personStatus = personStatus;
        this.probation = probation;
        this.planPositiveDate = planPositiveDate;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.licenseLevel = licenseLevel;
        this.placeOfNow = placeOfNow;
        if(hiredOperator != null){
            hiredOperatorName = hiredOperator.getName();
            if(hiredOperator.getCreatedTime() != null) {
                hiredOperatorDate = com.bcxin.Infrastructures.utils.DateUtil.format2ShortDate(hiredOperator.getCreatedTime(),"yyyy-MM-dd HH:mm:ss");
            }
        }

        if (hiredDate != null) {
            try {
                this.workDays = DateUtil.between(DateUtils.parseDate(hiredDate), Timestamp.from(Instant.now()), DateUnit.DAY);
            }catch (Exception e){}
        } else {
            this.workDays = 0;
        }

        if(credentialType != null) {
            this.credentialTypeName = credentialType.getTypeName();
        }
        if(checkedStatus != null) {
            this.checkedStatusName = checkedStatus.getTypeName();
        }
        if(authenticateStatus != null) {
            this.authenticateStatusName = authenticateStatus.getTypeName();
        }
        if(occupationType != null) {
            this.occupationTypeName = occupationType.getTypeName();
        }
        if(sex != null) {
            this.sexName = sex.getTypeName();
        }
        if(insure != null) {
            this.insureStatus = insure.getTypeName();
        }else{
            this.insureStatus = TrueFalseStatus.False.getTypeName();
        }
        if(domainAdmin != null) {
            this.domainAdminStatus = domainAdmin.getTypeName();
        }
        if(deparAdmin != null) {
            this.deparAdminStatus = deparAdmin.getTypeName();
        }
        if(contractStatus != null) {
            this.contractStatusName = contractStatus.getTypeName();
        }
        if(cerStatus != null) {
            this.cerStatusName = cerStatus.getTypeName();
        }
        if(gradeCerStatus != null) {
            this.gradeCerStatusName = gradeCerStatus.getTypeName();
        }

        if(validDateFrom != null){
            this.validDate = com.bcxin.Infrastructures.utils.DateUtil.format2ShortDate(validDateFrom)+" 至 ";
        }else{
            this.validDate = " 至 ";
        }
        if(validDateTo != null){
            this.validDate = validDate + com.bcxin.Infrastructures.utils.DateUtil.format2ShortDate(validDateTo);
        }

        if(personStatus != null){
            this.personStatusName = personStatus.getTypeName();
        }

        if(placeOfNow != null){
            this.placeOfNowName = (placeOfNow.getProvince() != null && placeOfNow.getProvince().getName() != null)?placeOfNow.getProvince().getName():"";
            this.placeOfNowName += (placeOfNow.getCity() != null && placeOfNow.getCity().getName() != null) ?placeOfNow.getCity().getName():"";
            this.placeOfNowName += (placeOfNow.getDistrict() != null&& placeOfNow.getDistrict().getName() != null)  ?placeOfNow.getDistrict().getName():"";
            this.placeOfNowName += placeOfNow.getAddress() != null ?placeOfNow.getAddress():"";
        }
    }
}
