package com.bcxin.tenant.domain.repositories;

import com.bcxin.tenant.domain.entities.DepartmentAdminEntity;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;

import java.util.Collection;
import java.util.List;

public interface DepartmentAdminRepository {
    void create(DepartmentAdminEntity departmentAdmin);

    void update(List<DepartmentAdminEntity> departmentAdminList);

    void batchCreate(Collection<EmployeeEntity> employees, Collection<DepartmentEntity> departments);

    void batchDelete(Collection<String> employeeIds);

    Collection<DepartmentAdminEntity> getByIds(String organizationId, Collection<String> ids);

    Collection<DepartmentAdminEntity> getByEmployeeIds(String organizationId, Collection<String> employeeIds);

    void update(EmployeeEntity employeeEntity, Collection<DepartmentEntity> departmentEntities);

    List<DepartmentAdminEntity> getByDepartmentId(String departmentId);
}
