package com.bcxin.tenant.domain.readers.dtos;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import lombok.Getter;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

@Getter
public class EmployeeLeaveDto implements Serializable {
    private final String id;
    private final String name;
    private final String telephone;
    private String departName;
    private final CredentialType credentialType;
    private final String credentialNumber;
    private final Date hiredDate;
    private final Timestamp leaveTime;
    private final String leaveNote;
    private final String operatorName;
    private final Timestamp createdTime;
    private final TrueFalseStatus insure;

    public EmployeeLeaveDto(String id, String name, String telephone,
                            String departName, CredentialType credentialType,
                            String credentialNumber,
                            Date hiredDate,
                            Timestamp leaveTime,
                            String leaveNote,String operatorName,
                            Timestamp createdTime,
                            TrueFalseStatus insure
    ) {
        this.id = id;
        this.name = name;
        this.telephone = telephone;
        this.departName = departName;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.hiredDate = hiredDate;
        this.leaveTime = leaveTime;
        this.leaveNote = leaveNote;
        this.createdTime =createdTime;
        this.operatorName = operatorName;
        this.insure = insure;
    }

    public void assignDepart(String name) {
        this.departName = StrUtil.isEmpty(this.departName) ? name:this.departName+"、"+name;
    }

}
