package com.bcxin.tenant.domain.readers.dtos;

import com.bcxin.Infrastructures.enums.*;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import lombok.Getter;

import javax.persistence.Column;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.util.Date;
import java.util.List;

@Getter
public class EmployeeDetailDto extends TenantUserDto{
    private final String employeeId;
    private final String employeeDepartId;
    private final String employeeDepartName;
    private final String employeeSuperiorId;
    private final String employeeSuperiorName;
    private final Date employeeHiredDate;
    private final Date employeePositiveDate;
    private final String employeePosition;
    private final OccupationType employeeOccupationType;
    private final MasterSlaveType masterSlaveType;
    private final TrueFalseStatus insure;
    private final Date employeeLeaveDate;
    private final String employeeLeaveNote;
    private final String salary;
    private List<DepartDto> departs;

    /**
     * 面谈记录
     */
    private final String interview;

    /**
     * 员工状态（选填，单选：全职/兼职/试用/实习）
     */
    private final PersonStatus personStatus;

    /**
     * 试用期 数字
     */
    private final String probation;

    /**
     * 原定转正日期 年月日
     */
    private final Date planPositiveDate;

    public EmployeeDetailDto(String employeeId,
                             TrueFalseStatus insure,
                             String employeeDepartId,
                             String employeeDepartName,
                             String employeeSuperiorId, String employeeSuperiorName, Date employeeHiredDate,
                             Date employeePositiveDate,
                             String employeePosition, OccupationType employeeOccupationType,
                             String id,
                             String name,
                             String email,
                             String nicky,
                             String telephone,
                             String lonLatJson,
                             UserCheckedStatus checkedStatus,
                             RealNameAuthenticatedStatus authenticateStatus,
                             String authenticatedResult,
                             String headPhoto, Sex sex, String nation,Integer workYear, String diseasesHistory, String politicsStatus,
                             String stature, String militaryStatus, Date birthdate, String education,
                             String householdType, String nativePlace, String maritalStatus,
                             String oneInchColorWhitePhoto,
                             String twoInchColorBluePhoto, MasterSlaveType masterSlaveType,
                             String cid,
                             String emergencyContact,
                             String emergencyPhone,
                             String licenseLevel,
                             LocationValueType placeOfNow,
                             CredentialType credentialType,
                             String credentialName,
                             String credentialNumber,
                             Date credentialValidDateFrom, Date credentialValidDateTo,
                             String credentialFrontPhoto,
                             String credentialReversePhoto,
                             String credentialAddress,
                             String credentialHeadPhoto,
                             Date employeeLeaveDate,
                             String employeeLeaveNote,
                             String thirdPartyLoginNo,
                             String imIdentity,
                             String interview,
                             PersonStatus personStatus,
                             String probation,
                             Date planPositiveDate,String certificatePhoto,String salary
                             ) {
        super(id, name, email, nicky, telephone, lonLatJson, checkedStatus, authenticateStatus, authenticatedResult,
                headPhoto, sex, nation,workYear,diseasesHistory, politicsStatus, stature,
                militaryStatus, birthdate, education, householdType, nativePlace, maritalStatus, oneInchColorWhitePhoto,
                twoInchColorBluePhoto, cid,
                emergencyContact,
                emergencyPhone,
                licenseLevel,
                placeOfNow,
                credentialType, credentialName, credentialNumber,
                credentialValidDateFrom, credentialValidDateTo,
                credentialFrontPhoto, credentialReversePhoto,
                credentialAddress,
                credentialHeadPhoto,thirdPartyLoginNo,imIdentity,certificatePhoto);

        this.insure = insure;
        this.employeeId = employeeId;
        this.employeeSuperiorId = employeeSuperiorId;
        this.employeeSuperiorName = employeeSuperiorName;
        this.employeeHiredDate = employeeHiredDate;
        this.employeePositiveDate = employeePositiveDate;
        this.employeePosition = employeePosition;
        this.employeeOccupationType = employeeOccupationType;
        this.employeeDepartId = employeeDepartId;
        this.employeeDepartName = employeeDepartName;
        this.masterSlaveType = masterSlaveType;
        this.employeeLeaveDate = employeeLeaveDate;
        this.employeeLeaveNote = employeeLeaveNote;
        this.interview = interview;
        this.personStatus = personStatus;
        this.probation = probation;
        this.planPositiveDate = planPositiveDate;
        this.salary = salary;
    }

    public void assignDepart(List<DepartDto> departs) {
        this.departs = departs;
    }
}
