package com.bcxin.tenant.domain.readers.criterias;

import com.bcxin.Infrastructures.CriteriaAbstract;
import com.bcxin.Infrastructures.enums.OccupationType;
import lombok.Getter;

import java.util.List;
@Getter
public class InvitedToJoinQueuesCriteria extends CriteriaAbstract {

    private final String keyword;

    private final List<String> departIds;

    private final List<OccupationType> occupationTypes;

    public InvitedToJoinQueuesCriteria(int pageIndex, int pageSize,String keyword, List<String> departIds, List<OccupationType> occupationTypes) {
        super(pageIndex,pageSize);
        this.keyword = keyword;
        this.departIds = departIds;
        this.occupationTypes = occupationTypes;
    }

    public static InvitedToJoinQueuesCriteria create(int pageIndex, int pageSize,String keyword, List<String> departIds, List<OccupationType> occupationTypes){
        return new InvitedToJoinQueuesCriteria(pageIndex,pageSize,keyword,departIds,occupationTypes);
    }
}
