package com.bcxin.tenant.domain.readers.criterias;

import com.bcxin.Infrastructures.CriteriaAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class DepartAdminCriteria extends CriteriaAbstract {
    private final String employeeId;

    private final Collection<String> departId;

    private final Collection<String> adminDepartIds;

    private final String keyword;

    public DepartAdminCriteria(int pageIndex, int pageSize, String employeeId,Collection<String> departId,Collection<String> adminDepartIds,String keyword) {
        super(pageIndex, pageSize);
        this.employeeId = employeeId;
        this.departId = departId;
        this.keyword = keyword;
        this.adminDepartIds = adminDepartIds;
    }

    public static DepartAdminCriteria create(int pageIndex, int pageSize, String employeeId,Collection<String> departId,Collection<String> adminDepartIds,String keyword) {
        return new DepartAdminCriteria(pageIndex, pageSize, employeeId,departId,adminDepartIds,keyword);
    }
}