package com.bcxin.tenant.domain.snapshots;

import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;

@Data
public class GisLocationSnapshot implements Serializable {
    private String latitude;
    private String longitude;
    private String time;

    public static GisLocationSnapshot create(String latitude,String longitude) {
        GisLocationSnapshot snapshot = new GisLocationSnapshot();
        snapshot.setLatitude(latitude);
        snapshot.setLongitude(longitude);
        snapshot.setTime(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(Timestamp.from(Instant.now())));

        return snapshot;
    }
}
