package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.DepartImPermissionType;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import lombok.Getter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Getter
public class DepartmentCommand extends CommandAbstract {
    private final String organizationId;
    private final String name;
    private final String code;
    private final String parentId;
    private final int displayOrder;
    private final List<String> leaderEmployeeIdList;
    private DepartImPermissionType permissionType;
    private Collection<String> allowedDepartIds;

    public DepartmentCommand(String organizationId, String name,
                             String parentId, int displayOrder,
                             DepartImPermissionType permissionType,
                             Collection<String> allowedDepartIds,
                             List<String> leaderEmployeeIdList) {
        this.organizationId = organizationId;
        this.name = name;
        this.parentId = parentId;
        this.displayOrder = displayOrder;
        this.permissionType = permissionType;
        this.allowedDepartIds = allowedDepartIds;
        this.leaderEmployeeIdList = leaderEmployeeIdList;
        this.code = null;
    }

    public DepartmentCommand(String organizationId, String name,
                             String parentId, String code) {
        this.organizationId = organizationId;
        this.name = name;
        this.parentId = parentId;
        this.code = code;
        this.displayOrder = 1;
        this.permissionType = DepartImPermissionType.OnDepartAndSub;
        this.allowedDepartIds = null;
        this.leaderEmployeeIdList = Collections.singletonList("null");
    }



    public static DepartmentCommand create(String organizationId, String name,
                                           String parentId, int displayOrder,
                                           DepartImPermissionType permissionType,
                                           Collection<String> allowedDepartIds,
                                           List<String> leaderEmployeeIdList) {
        return new DepartmentCommand(organizationId, name, parentId, displayOrder, permissionType, allowedDepartIds, leaderEmployeeIdList);
    }

    public static DepartmentCommand create(String organizationId, String name,
                                           String parentId, String code) {
        return new DepartmentCommand(organizationId, name, parentId, code);
    }

    @Override
    public void validate() {
        super.validate();
        if(DepartImPermissionType.Special.equals(this.getPermissionType())){
            if(allowedDepartIds == null || allowedDepartIds.size() == 0){
                throw new BadTenantException("请选择可见指定部门!");
            }

        }
    }
}
