package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.Infrastructures.enums.CredentialType;
import lombok.Getter;

import java.util.Date;

/**
 * 通过Employee来创建租户信息
 */
@Getter
public class CreateTenantUserByEmployeeCommand extends CommandAbstract {
    private final String name;
    private final String telephone;
    private final CredentialType credentialType;
    private final String credentialNumber;
    private final EmployeeEntity employee;
    private final Sex sex;
    private final Date birthdate;
    private final String nation;
    private final String education;
    private final String politicsStatus;
    private final String militaryStatus;
    private final String maritalStatus;
    private final String emergencyContact;
    private final String emergencyPhone;
    private final String address;
    private final String householdType;

    public CreateTenantUserByEmployeeCommand(EmployeeEntity employee,
                                             String name,
                                             String telephone,
                                             CredentialType credentialType,
                                             String credentialNumber,
                                             Sex sex,
                                             Date birthdate,
                                             String nation,
                                             String education,
                                             String politicsStatus,
                                             String militaryStatus,
                                             String maritalStatus,
                                             String emergencyContact,
                                             String emergencyPhone,
                                             String address,
                                             String householdType) {
        this.name = name;
        this.telephone = telephone;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.employee = employee;
        this.sex = sex;
        this.birthdate = birthdate;
        this.nation = nation;
        this.education = education;
        this.politicsStatus = politicsStatus;
        this.militaryStatus = militaryStatus;
        this.maritalStatus = maritalStatus;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.address = address;
        this.householdType = householdType;
    }

    public static CreateTenantUserByEmployeeCommand create(EmployeeEntity employee,
                                                           String name,
                                                           String telephone,
                                                           CredentialType credentialType,
                                                           String credentialNumber,
                                                           Sex sex,
                                                           Date birthdate,
                                                           String nation,
                                                           String education,
                                                           String politicsStatus,
                                                           String militaryStatus,
                                                           String maritalStatus,
                                                           String emergencyContact,
                                                           String emergencyPhone,
                                                           String address,
                                                           String householdType) {
        return new CreateTenantUserByEmployeeCommand(employee, name, telephone, credentialType, credentialNumber,
                sex, birthdate, nation, education, politicsStatus, militaryStatus,
                maritalStatus, emergencyContact, emergencyPhone, address, householdType);
    }
}
