package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class BatchDeleteDepartmentCommand extends CommandAbstract {
    private final String organizationId;
    private final Collection<String> departIds;

    public BatchDeleteDepartmentCommand(String organizationId, Collection<String> departIds) {
        this.organizationId = organizationId;
        this.departIds = departIds;
    }

    public static BatchDeleteDepartmentCommand create(String organizationId, Collection<String> departIds) {
        return new BatchDeleteDepartmentCommand(organizationId, departIds);
    }
}
