package com.bcxin.tenant.domain.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationDto;
import com.bcxin.tenant.domain.repositories.dtos.TenantUserRepositoryDto;

import java.util.Collection;

public interface OrganizationRepository extends EntityRepository<OrganizationEntity,String> {
    boolean existsByName(String name);

    OrganizationDto getDtoById(String id);

    Collection<TenantUserRepositoryDto> getOrganization(String id, TrueFalseStatus domainAdmin, ApprovedStatus status);

}
