package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.sql.Timestamp;
import java.time.Instant;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "organization_statistics_reports")
@Entity
public class OrganizationStatisticsReportEntity extends EntityAbstract implements IAggregate {

    @Id
    @Column(name = "id",nullable = false,length = 50)
    private String id;

    @Column(name = "unify_social_credit_code")
    private String unifySocialCreditCode;

    @Column(name = "count_of_members",nullable = false)
    private int countOfMembers;

    @Column(name = "last_sync_time",nullable = false)
    private Timestamp lastSyncTime;

    public OrganizationStatisticsReportEntity() {
    }

    public OrganizationStatisticsReportEntity(String id,String unifySocialCreditCode, int countOfMembers) {
        this.id = id;
        this.unifySocialCreditCode = unifySocialCreditCode;
        this.countOfMembers = countOfMembers;
        this.lastSyncTime = Timestamp.from(Instant.now());
    }

    public static OrganizationStatisticsReportEntity create(String id,String unifySocialCreditCode, int countOfMembers) {
        return new OrganizationStatisticsReportEntity(id,unifySocialCreditCode, countOfMembers);
    }

    public void change(String unifySocialCreditCode, int countOfMembers){
        this.setUnifySocialCreditCode(unifySocialCreditCode);
        this.setCountOfMembers(countOfMembers);
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    @Override
    public String toString() {
        if(this == null){
            return null;
        }
        return super.toString();
    }
}
