package com.bcxin.tenant.domain.v5.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class CreateMcNoticeCommand extends CommandAbstract {

    private final Collection<CreateMcNoticeCommandItem> items;

    public CreateMcNoticeCommand(Collection<CreateMcNoticeCommandItem> items) {
        this.items = items;
    }

    public static CreateMcNoticeCommand create(Collection<CreateMcNoticeCommandItem> items){
        return new CreateMcNoticeCommand(items);
    }

    @Getter
    public static class CreateMcNoticeCommandItem{
        private final String toUserId;
        private final String summary;
        private final String linkParams;
        private final String domainId;
        private final String module;
        private final String subjectType;
        private final String content;

        public CreateMcNoticeCommandItem(String toUserId,
                                     String summary, String linkParams,
                                     String domainId, String module,
                                     String subjectType, String content) {
            this.toUserId = toUserId;
            this.summary = summary;
            this.linkParams = linkParams;
            this.domainId = domainId;
            this.module = module;
            this.subjectType = subjectType;
            this.content = content;
        }

        public static CreateMcNoticeCommandItem create(String toUserId,
                                                       String summary, String linkParams,
                                                       String domainId, String module,
                                                       String subjectType, String content){
            return new CreateMcNoticeCommandItem(toUserId,summary,linkParams,domainId,module,subjectType,content);
        }
    }
}
