package com.bcxin.tenant.domain.v5.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "mc_notice")
@Entity
public class TMcNoticeEntity extends EntityAbstract implements IAggregate {
    @Id
    private String id;
    private int isRead;
    private String summary;
    private String toUserId;
    private Timestamp createTime;
    private String linkParams;
    private String module;
    private String domainId;
    private String subjectType;
    private String content;

    public TMcNoticeEntity() {
        this.createTime = Timestamp.from(Instant.now());
        this.isRead = 0;
    }

    public static TMcNoticeEntity create(String toUserId,
                                         String summary, String linkParams,
                                         String domainId, String module,
                                         String subjectType, String content) {
        TMcNoticeEntity entity = new TMcNoticeEntity();
        entity.setId(UUIDUtil.getShortUuid());
        entity.setToUserId(toUserId);
        entity.setSummary(summary);
        entity.setLinkParams(linkParams);
        entity.setDomainId(domainId);
        entity.setModule(module);
        entity.setSubjectType(subjectType);
        entity.setContent(content);

        return entity;
    }
}
