/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.services.impls;

import cn.hutool.core.util.ObjectUtil;
import com.bcxin.backend.domain.services.ConvertService;
import com.bcxin.backend.domain.syncs.dtos.SharedConvertDto;
import com.bcxin.backend.domain.utils.PDFUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class ConvertServiceImpl
implements ConvertService {
    private static final Logger log = LoggerFactory.getLogger(ConvertServiceImpl.class);
    @Value(value="${myapps.storage.root}")
    String rootPath;

    @Override
    public String execConvertHtmltopdfForTemp(SharedConvertDto convertDto) throws IOException {
        String string;
        block18: {
            String newPath;
            Exception lastException;
            StopWatch stopWatch;
            block16: {
                String string2;
                block17: {
                    File pdfFile;
                    String pdfFilePath;
                    block14: {
                        String string3;
                        block15: {
                            String pdfPath;
                            block12: {
                                String string4;
                                block13: {
                                    block10: {
                                        String string5;
                                        block11: {
                                            stopWatch = new StopWatch();
                                            lastException = null;
                                            stopWatch.start();
                                            if (!StringUtils.isEmpty((CharSequence)convertDto.getTempUrl()) && !ObjectUtil.isEmpty((Object)convertDto.getFormData())) break block10;
                                            string5 = null;
                                            if (lastException == null) break block11;
                                            stopWatch.stop();
                                            log.warn("====> HTML(url={},data={})\u8f6c\u4e3aPDF\u6210\u529f; \u8017\u65f6{}\u79d2", new Object[]{convertDto.getTempUrl(), convertDto.getFormData(), stopWatch.getTotalTimeSeconds()});
                                        }
                                        return string5;
                                    }
                                    JSONObject data = JSONObject.fromObject((Object)convertDto.getFormData());
                                    String string6 = pdfPath = ObjectUtil.isEmpty((Object)data.get("unSignaturePDF")) ? "" : data.get("unSignaturePDF") + "";
                                    if (!StringUtils.isEmpty((CharSequence)pdfPath)) break block12;
                                    string4 = null;
                                    if (lastException == null) break block13;
                                    stopWatch.stop();
                                    log.warn("====> HTML(url={},data={})\u8f6c\u4e3aPDF\u6210\u529f; \u8017\u65f6{}\u79d2", new Object[]{convertDto.getTempUrl(), convertDto.getFormData(), stopWatch.getTotalTimeSeconds()});
                                }
                                return string4;
                            }
                            pdfFilePath = this.rootPath + pdfPath;
                            pdfFile = new File(pdfFilePath);
                            if (!pdfFile.getParentFile().exists()) {
                                pdfFile.getParentFile().mkdirs();
                            }
                            PDFUtils.generatePdfByOpenhtmltopdf(convertDto.getTempUrl(), pdfFilePath, convertDto.getFormData());
                            pdfFile = new File(pdfFilePath);
                            if (pdfFile.length() != 0L) break block14;
                            pdfFile.delete();
                            string3 = null;
                            if (lastException == null) break block15;
                            stopWatch.stop();
                            log.warn("====> HTML(url={},data={})\u8f6c\u4e3aPDF\u6210\u529f; \u8017\u65f6{}\u79d2", new Object[]{convertDto.getTempUrl(), convertDto.getFormData(), stopWatch.getTotalTimeSeconds()});
                        }
                        return string3;
                    }
                    newPath = pdfFilePath.replace(".temp", ".pdf");
                    File newFile = new File(newPath);
                    boolean flag = pdfFile.renameTo(newFile);
                    if (flag) break block16;
                    pdfFile.delete();
                    string2 = null;
                    if (lastException == null) break block17;
                    stopWatch.stop();
                    log.warn("====> HTML(url={},data={})\u8f6c\u4e3aPDF\u6210\u529f; \u8017\u65f6{}\u79d2", new Object[]{convertDto.getTempUrl(), convertDto.getFormData(), stopWatch.getTotalTimeSeconds()});
                }
                return string2;
            }
            try {
                string = newPath;
                if (lastException == null) break block18;
            }
            catch (Exception ex) {
                try {
                    stopWatch.stop();
                    log.error("====> HTML(url={},data={})\u8f6c\u4e3aPDF\u5f02\u5e38; \u8017\u65f6{}\u79d2", new Object[]{convertDto.getTempUrl(), convertDto.getFormData(), stopWatch.getTotalTimeSeconds()});
                    lastException = ex;
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (lastException != null) {
                        stopWatch.stop();
                        log.warn("====> HTML(url={},data={})\u8f6c\u4e3aPDF\u6210\u529f; \u8017\u65f6{}\u79d2", new Object[]{convertDto.getTempUrl(), convertDto.getFormData(), stopWatch.getTotalTimeSeconds()});
                    }
                    throw throwable;
                }
            }
            stopWatch.stop();
            log.warn("====> HTML(url={},data={})\u8f6c\u4e3aPDF\u6210\u529f; \u8017\u65f6{}\u79d2", new Object[]{convertDto.getTempUrl(), convertDto.getFormData(), stopWatch.getTotalTimeSeconds()});
        }
        return string;
    }

    public String existsPdfCopy(SharedConvertDto convertDto) {
        File[] fi;
        int count = 80;
        if (convertDto.getFormData() != null) {
            count = Integer.parseInt(String.valueOf(convertDto.getFormData()));
        }
        if (StringUtils.isEmpty((CharSequence)convertDto.getTempUrl())) {
            return null;
        }
        String tempFilePath = this.rootPath + convertDto.getTempUrl();
        String inFilePath = this.rootPath + convertDto.getTempUrl().replace("/temp", "/in");
        log.warn("=======> existsPdfCopy.tempFile:{};inFilePath={}", (Object)tempFilePath, (Object)inFilePath);
        File tempFile = new File(tempFilePath);
        if (!tempFile.exists()) {
            return null;
        }
        File inFile = new File(inFilePath);
        if (!inFile.exists()) {
            inFile.mkdirs();
        }
        if ((fi = inFile.listFiles()) != null && fi.length > 20) {
            log.info("=======> \u7b7e\u7ae0\u4e1a\u52a1\uff1a\u526a\u5207\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5f02\u5e38\uff0c\u5269\u4f59\u6587\u4ef6\u8d8520\u4e2a\uff0c\u6253\u56de");
            return null;
        }
        File[] fa = tempFile.listFiles();
        int pCount = 0;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < fa.length; ++i) {
            if (!fa[i].getName().contains(".pdf") || pCount >= count) continue;
            list.add(fa[i].getName());
            ++pCount;
        }
        if (list.size() == 0) {
            return null;
        }
        ArrayList usrlist = Lists.newArrayList();
        for (String fileName : list) {
            try {
                File temp = new File(tempFilePath + "/" + fileName);
                if (!temp.exists()) {
                    log.error("\u975e\u9884\u671f\u884c\u4e3a\u62f7\u8d1d\u6570\u636e\u5230\u5f85\u7b7e\u7ae0\u76ee\u5f55\u7684\u65f6\u5019; \u6587\u4ef6({})\u7a81\u7136\u627e\u4e0d\u5230", (Object)temp.getPath());
                    continue;
                }
                Files.move(Paths.get(tempFilePath + "/" + fileName, new String[0]), Paths.get(inFilePath + "/" + fileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                usrlist.add(fileName);
            }
            catch (IOException e) {
                log.info("=======> \u7b7e\u7ae0\u4e1a\u52a1\uff1a\u526a\u5207\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5f02\u5e38\uff0c\u6587\u4ef6\u540d\uff1a" + fileName + "\uff0cERROR\uff1a" + e.getMessage());
            }
        }
        log.info("=======> \u7b7e\u7ae0\u4e1a\u52a1\uff1a\u526a\u5207\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5f02\u5e38\uff0c\u5df2\u526a\u5207\uff1a{}\u4e2a", (Object)usrlist.size());
        StringBuilder result = new StringBuilder();
        for (String fileName : usrlist) {
            result.append(fileName);
            result.append(";");
        }
        return "0," + result;
    }

    public File[] findInFile(String tempUrl) {
        String inFilePath = this.rootPath + tempUrl.replace("/temp", "/in");
        File inFile = new File(inFilePath);
        if (!inFile.exists()) {
            System.err.println("=======> existsPdfCopy.findInFile.inFile:null");
            return null;
        }
        File[] fi = inFile.listFiles();
        System.err.println("=======> existsPdfCopy.findInFile.fi:" + fi);
        if (fi.length == 0) {
            System.err.println("=======> existsPdfCopy.findInFile.fi:null");
            return null;
        }
        return fi;
    }

    public void delInPDF(SharedConvertDto convertDto) {
        String inFilePath = this.rootPath + convertDto.getTempUrl().replace("/temp", "/in");
        String outFilePath = this.rootPath + convertDto.getTempUrl().replace("/temp", "/out");
        File inFile = new File(inFilePath);
        if (!inFile.exists()) {
            return;
        }
        File outFile = new File(outFilePath);
        if (!outFile.exists()) {
            return;
        }
        File[] ifi = inFile.listFiles();
        File[] ofi = outFile.listFiles();
        if (ifi.length != 0 && ofi.length != 0) {
            File fs;
            int i;
            String outFName = "";
            for (i = 0; i < ofi.length; ++i) {
                fs = ofi[i];
                outFName = outFName + fs.getName();
            }
            if (StringUtils.isNotEmpty((CharSequence)outFName)) {
                for (i = 0; i < ifi.length; ++i) {
                    fs = ifi[i];
                    if (!outFName.contains(fs.getName()) || !fs.exists() || fs.isDirectory()) continue;
                    fs.delete();
                }
            }
        }
    }

    public void delSetFtpFile(String tempUrl, String fileNames) {
        File[] ofi;
        String inFilePath = this.rootPath + tempUrl.replace("/temp", "/in");
        String outFilePath = this.rootPath + tempUrl.replace("/temp", "/out");
        File inFile = new File(inFilePath);
        if (!inFile.exists()) {
            return;
        }
        File outFile = new File(outFilePath);
        if (!outFile.exists()) {
            return;
        }
        File[] ifi = inFile.listFiles();
        if (ifi.length != 0) {
            for (int i = 0; i < ifi.length; ++i) {
                File fs = ifi[i];
                if (!fileNames.contains(fs.getName()) || !fs.exists() || fs.isDirectory()) continue;
                fs.delete();
            }
        }
        if ((ofi = outFile.listFiles()).length != 0) {
            for (int i = 0; i < ofi.length; ++i) {
                File fs = ofi[i];
                if (!fileNames.contains(fs.getName()) || !fs.exists() || fs.isDirectory()) continue;
                fs.delete();
            }
        }
    }

    public void delInPDF(String tempUrl) {
        String inFilePath = this.rootPath + tempUrl.replace("/temp", "/in");
        File inFile = new File(inFilePath);
        if (!inFile.exists()) {
            return;
        }
        File[] ifi = inFile.listFiles();
        for (int i = 0; i < ifi.length; ++i) {
            File fs = ifi[i];
            if (fs.length() >= 5L || fs.isDirectory()) continue;
            fs.delete();
        }
    }

    public String existsScanSignature(SharedConvertDto convertDto) {
        if (StringUtils.isEmpty((CharSequence)convertDto.getTempUrl())) {
            return null;
        }
        return PDFUtils.uploadFtpFile(convertDto.getTempUrl(), this.rootPath);
    }

    public String existsScanSignatureByDayFile(SharedConvertDto convertDto) {
        if (StringUtils.isEmpty((CharSequence)convertDto.getTempUrl())) {
            return null;
        }
        return PDFUtils.uploadDayFile(convertDto.getTempUrl(), this.rootPath);
    }
}

