/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils.ftp;

import com.bcxin.backend.domain.utils.ftp.FtpConnection;
import com.bcxin.backend.domain.utils.ftp.FtpFactory;
import com.bcxin.backend.domain.utils.ftp.UploadResult;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadTask
implements Callable {
    private static final Logger logger = LoggerFactory.getLogger(UploadTask.class);
    private File file;
    private FtpConnection ftp;
    private String path;
    private String fileName;
    private FtpFactory factory;

    public UploadTask(FtpFactory factory, FtpConnection ftp, File file, String path, String fileName) {
        this.factory = factory;
        this.ftp = ftp;
        this.file = file;
        this.path = path;
        this.fileName = fileName;
    }

    public UploadResult call() throws Exception {
        UploadResult result = null;
        try {
            if (this.ftp == null) {
                UploadResult uploadResult = result = new UploadResult(this.file.getAbsolutePath(), false);
                return uploadResult;
            }
            if (!this.ftp.isConnected()) {
                this.factory.remove(this.ftp);
                this.ftp = new FtpConnection();
            }
            result = new UploadResult(this.file.getName(), this.ftp.upload(this.path, this.fileName, this.file));
        }
        catch (IOException ex) {
            result = new UploadResult(this.file.getName(), false);
            logger.error("\u4e0a\u4f20Ftp\u53d1\u751f\u5f02\u5e38:{}", (Object)result, (Object)ex);
        }
        finally {
            this.factory.relase(this.ftp);
        }
        return result;
    }
}

