package com.bcxin.backend.strategy.bg;

import com.bcxin.backend.common.BgConstant;
import com.bcxin.backend.common.utils.SpringContextUtils;
import com.bcxin.backend.strategy.bg.impl.CommonBgScreeningCompare;
import com.bcxin.backend.strategy.bg.impl.HunanBgScreeningCompare;
import com.bcxin.backend.strategy.bg.impl.MockBgScreeningCompare;

/**
 * 背筛比对工厂
 */
public class BgScreeningStrategyFactory {

    /**
     * 根据服务key，获取背筛比对接口实现类
     */
    public static BgScreeningStrategy getBYServerKey(String serverKey) {
        switch (serverKey) {
            case BgConstant.BG_SCREENING_SERVER_KEY_COMMON:
                return SpringContextUtils.getBean(CommonBgScreeningCompare.class);
            case BgConstant.BG_SCREENING_SERVER_KEY_HUNAN:
                return SpringContextUtils.getBean(HunanBgScreeningCompare.class);
            case BgConstant.BG_SCREENING_SERVER_KEY_MOCK:
                return SpringContextUtils.getBean(MockBgScreeningCompare.class);
        }
        throw new RuntimeException(String.format("获取处置策略异常，无此处置类型，auditTypeEnum：%s", serverKey));
    }

}
