package com.bcxin.backend.domain.syncs.dtos;

import com.bcxin.runtime.domain.snapshoots.FormSyncTargetConfigSnapshot;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Getter
@Setter(AccessLevel.PRIVATE)
public class FtpDataImportRequestDto {
    private final String regionId;
    private final String srcApp;
    private final String targetApp;
    private final String targetServiceUrl;
    private final String callbackUrl;
    private final String outRequsetDirKey;
    private boolean isPostFile;
    private String fileUrls;
    private String data;
    private Map<String, String> headers;
    private final boolean isSyncViaFtp;
    private Map<String, String> pathMap;

    public FtpDataImportRequestDto(String regionId,
                                   String srcApp, String targetApp,
                                   String targetServiceUrl,
                                   String callbackUrl,
                                   Boolean isSyncViaFtp,
                                   String outRequsetDirKey) {
        this.regionId = regionId;
        this.srcApp = srcApp;
        this.targetApp = targetApp;
        this.targetServiceUrl = targetServiceUrl;
        this.callbackUrl = callbackUrl;
        this.outRequsetDirKey = outRequsetDirKey;
        this.isSyncViaFtp = isSyncViaFtp;
        this.headers = new HashMap<>();
        this.headers.put("data-from-body", "true");
        this.headers.put("content-type", "application/json");
    }

    public String getBusinessType() {
        return "1001";
    }

    public String getBusinessId() {
        return "1001000000001";
    }

    public String getFileType() {
        if (isPostFile) {
            return "annex";
        } else {
            return "normal";
        }
    }

    public boolean isNeedFile2Execute() {
        if (this.isPostFile()) {
            return this.getFileUrls() != null &&
                    Arrays.stream(this.getFileUrls().split(",")).anyMatch(ii -> StringUtils.hasLength(ii) &&
                            !"null".equalsIgnoreCase(ii));
        }

        return true;
    }

    public void assign(boolean isPostFile, String data, String fileUrls,Map<String, String> pathMap) {
        this.setPostFile(isPostFile);
        this.setFileUrls(fileUrls);
        this.setData(data);
        this.setPathMap(pathMap);
    }

    public static FtpDataImportRequestDto create(String regionId,
                                                 String srcApp, String targetApp,
                                                 String targetServiceUrl,
                                                 String callbackUrl,
                                                 Boolean isSyncViaFtp,
                                                 String outRequsetDirKey) {
        return new FtpDataImportRequestDto(regionId, srcApp, targetApp, targetServiceUrl, callbackUrl, isSyncViaFtp, outRequsetDirKey);
    }

    public String getRequestUrl(FormSyncTargetConfigSnapshot configSnapshot) {
        if (!isSyncViaFtp) {
            return String.format("%s/%s", srcApp, targetServiceUrl);
        }

        return configSnapshot.getUrl();
    }
}

