package com.bcxin.backend.domain.syncs.components;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class HttpRequestProviderImpl implements HttpRequestProvider{
    private final JsonProvider jsonProvider;

    public HttpRequestProviderImpl(JsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }


    @Override
    public HttpResponse post(String url, Map<String, Object> headers, String data) {

        try {
            HttpRequest request = HttpRequest.post(url);
            if (headers != null) {
                headers.forEach((key, value) -> {
                    request.header(key, String.valueOf(value));
                });
            }

            HttpResponse response = request.body(data).execute();

            return response;
        } catch (Exception ex) {
            throw new SaasBadException(ex.toString());
        }
    }

    @Override
    public HttpResponse get(String url) {
        return HttpRequest.get(url).execute();
    }
}
