package com.bcxin.backend.domain.signature.service;

import com.bcxin.backend.core.exceptions.SaasNoSupportException;
import com.bcxin.backend.domain.signature.common.QzConstant;
import com.bcxin.backend.domain.signature.common.utils.SpringContextUtils;
import com.bcxin.backend.domain.signature.service.impls.BeiJingInSignatureToPDFCompare;
import com.bcxin.backend.domain.signature.service.impls.CommonSignatureToPDFCompare;
import com.bcxin.backend.domain.signature.service.impls.HuNanInSignatureToPDFCompare;
import com.bcxin.backend.domain.signature.service.impls.ShanXiInSignatureToPDFCompare;

/**
 * 电子签章工厂
 */
public class QzSignatureStrategyFactory {

    /**
     * 根据服务key，获取电子签章接口实现类
     */
    public static QzSignatureStrategy getBYServerKey(String serverKey) {
        switch (serverKey) {
            case QzConstant.QZ_SIGNATURE_SERVER_KEY_COMMON:
                return SpringContextUtils.getBean(CommonSignatureToPDFCompare.class);
            case QzConstant.QZ_SIGNATURE_SERVER_KEY_HUNANIN:
                return SpringContextUtils.getBean(HuNanInSignatureToPDFCompare.class);
            case QzConstant.QZ_SIGNATURE_SERVER_KEY_BEIJINGIN:
                return SpringContextUtils.getBean(BeiJingInSignatureToPDFCompare.class);
            case QzConstant.QZ_SIGNATURE_SERVER_KEY_SHANXIIN:
                return SpringContextUtils.getBean(ShanXiInSignatureToPDFCompare.class);
            default:
                throw new RuntimeException(String.format("获取处置策略异常，无此处置类型，auditTypeEnum：%s", serverKey));
        }
//        throw new RuntimeException(String.format("获取处置策略异常，无此处置类型，auditTypeEnum：%s", serverKey));
    }

}
