package com.bcxin.backend.domain.enums;

public enum ComparisonDocumentType {
    /*
     * 注：name 为业务名称；stamp_xy 为印章坐标:page 页码，left 左，right 右，top 上，bottom 下
     */
    //保安服务公司设立许可
    BASLXK_XK(13, "保安服务公司设立许可-准予许可决定书","1,465,507","","SELECT a.id AS 'business_id',a.item_notice_file AS 'path' FROM tlk_securitysevicek a WHERE a.item_auditStatus='1' AND a.item_notice_file IS NOT NULL AND a.item_notice_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='13');","tlk_securitysevicek","item_notice_file"),
    BASLXK_BXK(14, "保安服务公司设立许可-不予许可决定书","1,465,587","","SELECT a.id AS 'business_id',a.item_notice_file AS 'path' FROM tlk_securitysevicek a WHERE a.item_auditStatus='0' a.AND item_notice_file IS NOT NULL AND a.item_notice_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='14');","tlk_securitysevicek","item_notice_file"),
    BASLXK_ZSQZ_ZB(15, "保安服务公司设立许可-证书签章（正本）","1,851,614","","SELECT a.id AS 'business_id',a.item_security_z_file AS 'path' FROM tlk_securitysevicek a WHERE a.item_auditStatus='1' AND a.item_security_z_file IS NOT NULL AND a.item_security_z_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='15');","tlk_securitysevicek","item_security_z_file"),
    BASLXK_ZSQZ_FB(16, "保安服务公司设立许可-证书签章（副本）","1,264,396","","SELECT a.id AS 'business_id',a.item_security_f_file AS 'path' FROM tlk_securitysevicek a WHERE a.item_auditStatus='1' AND a.item_security_f_file IS NOT NULL AND a.item_security_f_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='16');","tlk_securitysevicek","item_security_f_file"),
    //保安服务公司名称变更
    MCBG_XK(23, "保安服务公司名称变更-准予许可决定书","1,465,507","","SELECT a.id AS 'business_id',a.item_notice_file AS 'path' FROM tlk_scope_nameChangeS a WHERE a.item_auditStatus='1' AND a.item_notice_file IS NOT NULL AND a.item_notice_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='23');","tlk_scope_nameChangeS","item_notice_file"),
    MCBG_BXK(24, "保安服务公司名称变更-不予许可决定书","1,465,587","","SELECT a.id AS 'business_id',a.item_notice_file AS 'path' FROM tlk_scope_nameChangeS a WHERE a.item_auditStatus='0' a.AND item_notice_file IS NOT NULL AND a.item_notice_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='24');","tlk_scope_nameChangeS","item_notice_file"),
    MCBG_ZSQZ_ZB(25, "保安服务公司名称变更-证书签章（正本）","1,851,614","","SELECT a.id AS 'business_id',a.item_security_z_file AS 'path' FROM tlk_scope_nameChangeS a WHERE a.item_auditStatus='1' AND a.item_security_z_file IS NOT NULL AND a.item_security_z_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='25');","tlk_scope_nameChangeS","item_security_z_file"),
    MCBG_ZSQZ_FB(26, "保安服务公司名称变更-证书签章（副本）","1,264,396","","SELECT a.id AS 'business_id',a.item_security_f_file AS 'path' FROM tlk_scope_nameChangeS a WHERE a.item_auditStatus='1' AND a.item_security_f_file IS NOT NULL AND a.item_security_f_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='26');","tlk_scope_nameChangeS","item_security_f_file"),
    //保安服务公司主要管理人员变更
    RYBG_XK(33, "保安服务公司主要管理人员变更-准予许可决定书","1,465,507","","SELECT a.id AS 'business_id',a.item_notice_file AS 'path' FROM tlk_SecurityOfficerChange a WHERE a.item_auditStatus='1' AND a.item_notice_file IS NOT NULL AND a.item_notice_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='33');","tlk_SecurityOfficerChange","item_notice_file"),
    RYBG_BXK(34, "保安服务公司主要管理人员变更-不予许可决定书","1,465,587","","SELECT a.id AS 'business_id',a.item_notice_file AS 'path' FROM tlk_SecurityOfficerChange a WHERE a.item_auditStatus='0' a.AND item_notice_file IS NOT NULL AND a.item_notice_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='34');","tlk_SecurityOfficerChange","item_notice_file"),
    //保安服务公司法定代表人变更
    DBRBG_XK(43, "保安服务公司法定代表人变更-准予许可决定书","1,465,507","","SELECT a.id AS 'business_id',a.item_notice_file AS 'path' FROM tlk_LegalChangeK a WHERE a.item_auditStatus='1' AND a.item_notice_file IS NOT NULL AND a.item_notice_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='43');","tlk_LegalChangeK","item_notice_file"),
    DBRBG_BXK(44, "保安服务公司法定代表人变更-不予许可决定书","1,465,587","","SELECT a.id AS 'business_id',a.item_notice_file AS 'path' FROM tlk_LegalChangeK a WHERE a.item_auditStatus='0' a.AND item_notice_file IS NOT NULL AND a.item_notice_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='44');","tlk_LegalChangeK","item_notice_file"),
    DBRBG_ZSQZ_ZB(45, "保安服务公司法定代表人变更-证书签章（正本）","1,851,614","","SELECT a.id AS 'business_id',a.item_security_z_file AS 'path' FROM tlk_LegalChangeK a WHERE a.item_auditStatus='1' AND a.item_security_z_file IS NOT NULL AND a.item_security_z_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='45');","tlk_LegalChangeK","item_security_z_file"),
    DBRBG_ZSQZ_FB(46, "保安服务公司法定代表人变更-证书签章（副本）","1,264,396","","SELECT a.id AS 'business_id',a.item_security_f_file AS 'path' FROM tlk_LegalChangeK a WHERE a.item_auditStatus='1' AND a.item_security_f_file IS NOT NULL AND a.item_security_f_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='46');","tlk_LegalChangeK","item_security_f_file"),
    //保安服务公司住所变更
    ZSBG_XK(53, "保安服务公司住所变更-准予许可决定书","1,465,507","","SELECT a.id AS 'business_id',a.item_notice_file AS 'path' FROM tlk_scope_addressChangeK a WHERE a.item_auditStatus='1' AND a.item_notice_file IS NOT NULL AND a.item_notice_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='53');","tlk_scope_addressChangeK","item_notice_file"),
    ZSBG_BXK(54, "保安服务公司住所变更-不予许可决定书","1,465,587","","SELECT a.id AS 'business_id',a.item_notice_file AS 'path' FROM tlk_scope_addressChangeK a WHERE a.item_auditStatus='0' a.AND item_notice_file IS NOT NULL AND a.item_notice_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='54');","tlk_scope_addressChangeK","item_notice_file"),
    ZSBG_ZSQZ_ZB(55, "保安服务公司住所变更-证书签章（正本）","1,851,614","","SELECT a.id AS 'business_id',a.item_security_z_file AS 'path' FROM tlk_scope_addressChangeK a WHERE a.item_auditStatus='1' AND a.item_security_z_file IS NOT NULL AND a.item_security_z_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='55');","tlk_scope_addressChangeK","item_security_z_file"),
    ZSBG_ZSQZ_FB(56, "保安服务公司住所变更-证书签章（副本）","1,264,396","","SELECT a.id AS 'business_id',a.item_security_f_file AS 'path' FROM tlk_scope_addressChangeK a WHERE a.item_auditStatus='1' AND a.item_security_f_file IS NOT NULL AND a.item_security_f_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='56');","tlk_scope_addressChangeK","item_security_f_file"),
    GHZS_ZSQZ_ZB(65, "更换保安服务许可证-证书签章（正本）","1,851,614","","SELECT a.id AS 'business_id',a.item_security_z_file AS 'path' FROM tlk_securityservicelicensechange a WHERE a.item_auditStatus='1' AND a.item_security_z_file IS NOT NULL AND a.item_security_z_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='65');","tlk_securityservicelicensechange","ITEM_SECURITY_Z_FILE"),
    GHZS_ZSQZ_FB(66, "更换保安服务许可证-证书签章（副本）","1,264,396","","SELECT a.id AS 'business_id',a.item_security_f_file AS 'path' FROM tlk_securityservicelicensechange a WHERE a.item_auditStatus='1' AND a.item_security_f_file IS NOT NULL AND a.item_security_f_file != '' AND !EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = a.id and m.business_type='66');","tlk_securityservicelicensechange","ITEM_SECURITY_F_FILE");

    private final int value;
    private final String name;
    private final String updateSql;
    private final String selectSql;
    private final String tableName;
    private final String fileField;
    private final String stampXy;

    ComparisonDocumentType(int value, String name, String stampXy, String updateSql, String selectSql, String tableName, String fileField) {
        this.value = value;
        this.name = name;
        this.stampXy = stampXy;
        this.updateSql = updateSql;
        this.selectSql = selectSql;
        this.tableName = tableName;
        this.fileField = fileField;
    }

    public static ComparisonDocumentType getByValue(int value) {
        for (ComparisonDocumentType documentType : ComparisonDocumentType.values()) {
            if (value==documentType.getValue()) {
                return documentType;
            }
        }
        return null;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public String getStampXy() {
        return stampXy;
    }

    public String getUpdateSql() {
        return updateSql;
    }

    public String getSelectSql() {
        return selectSql;
    }
    public String getTableName() {
        return tableName;
    }
    public String getFileField() {
        return fileField;
    }
}
