/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.services.impls;

import cn.hutool.core.util.ObjectUtil;
import com.bcxin.backend.domain.services.ConvertService;
import com.bcxin.backend.domain.syncs.dtos.SharedConvertDto;
import com.bcxin.backend.domain.utils.PDFUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ConvertServiceImpl
implements ConvertService {
    @Value(value="${myapps.storage.root}")
    String rootPath;

    @Override
    public String execConvertHtmltopdfForTemp(SharedConvertDto convertDto) throws IOException {
        String pdfPath;
        if (StringUtils.isEmpty((CharSequence)convertDto.getTempUrl()) || ObjectUtil.isEmpty((Object)convertDto.getFormData())) {
            return null;
        }
        JSONObject data = JSONObject.fromObject((Object)convertDto.getFormData());
        String string = pdfPath = ObjectUtil.isEmpty((Object)data.get("unSignaturePDF")) ? "" : data.get("unSignaturePDF") + "";
        if (StringUtils.isEmpty((CharSequence)pdfPath)) {
            return null;
        }
        String pdfFilePath = this.rootPath + pdfPath;
        File pdfFile = new File(pdfFilePath);
        if (!pdfFile.getParentFile().exists()) {
            pdfFile.getParentFile().mkdirs();
        }
        PDFUtils.generatePdfByOpenhtmltopdf(convertDto.getTempUrl(), pdfFilePath, convertDto.getFormData());
        return pdfPath;
    }

    public static void main(String[] args) throws IOException {
        SharedConvertDto convertDto = new SharedConvertDto();
        convertDto.setTempUrl("https://v5qy.de.baibaodun.com.cn/static/signon/elesign/qualicerttemp_zgz.html");
        convertDto.setFormData("{\"address\":\"\u5c71\u4e1c\u7701\u9633\u8c37\u53bf\u9ad8\u5e99\u738b\u9547\u90b5\u697c\u6751774\u53f7\",\"certificateno\":\"\u4eac2023123227\",\"day\":\"02\",\"fzDate\":\"2023-01-06\",\"headphoto\":\"https://02obs-file-system-obpm-uploads.obs.cn-north-1.myhuaweicloud.com/2022/10-12/c9a018e2-082a-4afa-b2d4-b761763dff08/1665571917323.jpg\",\"idcardno\":\"371521200403026118\",\"isSignature\":\"1\",\"month\":\"03\",\"name\":\"\u90b5\u8d35\u9756\",\"unSignaturePDF\":\"/uploads/pdf/dianziqianzhang/temp/queueId_2604.pdf\",\"year\":\"2004\",\"zDay\":\"06\",\"zMonth\":\"01\",\"zYear\":\"2023\"}");
        PDFUtils.generatePdfByOpenhtmltopdf(convertDto.getTempUrl(), "D:\\data\\upload\\a1.pdf", convertDto.getFormData());
    }

    public String existsPdfCopy(SharedConvertDto convertDto) {
        int i;
        File[] fa;
        int count = 30;
        if (convertDto.getFormData() != null) {
            count = (Integer)convertDto.getFormData();
        }
        if (StringUtils.isEmpty((CharSequence)convertDto.getTempUrl())) {
            return null;
        }
        String tempFilePath = this.rootPath + convertDto.getTempUrl();
        String inFilePath = this.rootPath + convertDto.getTempUrl().replace("/temp", "/in");
        File tempFile = new File(tempFilePath);
        if (!tempFile.exists()) {
            return null;
        }
        File inFile = new File(inFilePath);
        if (!inFile.exists()) {
            return null;
        }
        File[] fi = inFile.listFiles();
        if (fi.length != 0) {
            try {
                FileUtils.cleanDirectory((File)inFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((fa = tempFile.listFiles()).length == 0) {
            return null;
        }
        if (fa.length < 30) {
            count = fa.length;
        }
        String[] fileNames = new String[count];
        for (i = 0; i < count; ++i) {
            File fs = fa[i];
            fileNames[i] = fs.getName();
        }
        for (i = 0; i < count; ++i) {
            try {
                Files.move(Paths.get(tempFilePath + "/" + fileNames[i], new String[0]), Paths.get(inFilePath + "/" + fileNames[i], new String[0]), StandardCopyOption.REPLACE_EXISTING);
                continue;
            }
            catch (IOException e) {
                System.err.println("=======> \u7b7e\u7ae0\u4e1a\u52a1\uff1a\u526a\u5207\u6587\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55\u5f02\u5e38\uff0c\u6587\u4ef6\u540d\uff1a" + fileNames[i] + "\uff0cERROR\uff1a" + e.getMessage());
            }
        }
        StringBuilder result = new StringBuilder();
        for (String fileName : fileNames) {
            result.append(fileName);
            result.append(";");
        }
        return "0," + result;
    }

    public String existsScanSignature(SharedConvertDto convertDto) {
        if (StringUtils.isEmpty((CharSequence)convertDto.getTempUrl())) {
            return null;
        }
        return PDFUtils.uploadFtpFile(convertDto.getTempUrl(), this.rootPath);
    }
}

