package com.bcxin.backend.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description: 背筛问题结果表
 * author: linchunpeng
 * date:  2023-07-12 18:17
 */
@Data
@TableName("bg_screening_user_results")
public class BgScreeningUserResult {

    private static final long serialVersionUID = 1L;

    @TableId(value = "pkId")
    private Long pkId;

    @TableField(value = "ID")
    private String id;

    //类型: 1在逃,2吸毒，3重点，4重要信息有误
    @TableField(value = "TYPE")
    private Integer type;

    //监管企业域id
    @TableField(value = "DOMAINID")
    private String domainId;

    //问题类型
    @TableField(value = "QUESTIONTYPE")
    private String questionType;

    //用户id
    @TableField(value = "USERID")
    private String userId;

    //姓名
    @TableField(value = "SECURITYNAME")
    private String securityName;

    //身份证号
    @TableField(value = "DOCUMENTID")
    private String documentId;

    //手机号码
    @TableField(value = "PHONE")
    private String phone;

    //所属企业
    @TableField(value = "COMPANYNAME")
    private String companyName;

    //所属企业ID
    @TableField(value = "DOMAIN_ID")
    private String companyId;

    //就职状态 1在职 0 离职
    @TableField(value = "WORKSTATUS")
    private String workStatus;

    //所属监管机构
    @TableField(value = "REGISTERPOLICEADDRESS")
    private String registerPoliceAddress;

    //监管处理状态 0未处理  1已处理
    @TableField(value = "POLICESTATUS")
    private String policeStatus;

    //监管处理对内意见
    @TableField(value = "POLICEINTERNALADVICE")
    private String policeInternalAdvice;

    //监管处理对外意见
    @TableField(value = "POLICEEXTERNALADVICE")
    private String policeExternalAdvice;

    //监管建议处理措施
    @TableField(value = "POLICESUGGESTEDTREATMENT")
    private String policeSuggestedTreatment;

    //监管处理人
    @TableField(value = "POLICEMAN")
    private String policeMan;

    //监管处理人所属机构
    @TableField(value = "POLICEORGANIZATION")
    private String policeOrganization;

    //监管处理时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "POLICETIME")
    private Date policeTime;

    //企业处理人
    @TableField(value = "COMPANYMAN")
    private String companyMan;

    //企业处理时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "COMPANYTIME")
    private Date companyTime;

    //企业处理状态 1处理过  0 或null 未处理
    @TableField(value = "COMPANYSTATUS")
    private String companyStatus;

    //企业处理结果及反馈
    @TableField(value = "COMPANYTREATMENT")
    private String companyTreatment;

    //所属监管机构id
    @TableField(value = "REGISTERPOLICEADDRESSID")
    private String registerPoliceAddressId;

    //所属监管机构层级ID
    @TableField(value = "registerPoliceIDIndex")
    private String registerPoliceIdIndex;

    //比对时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "COMPARETIME")
    private Date compareTime;

    //第一次比对时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "firstcompareTime")
    private Date firstCompareTime;

    //最后更新时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "lastmodified")
    private Date lastModified;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "created")
    private Date created;

    //入职时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "Entry_Time")
    private Date entryTime;

    //处理意见
    @TableField(value = "POLICEEXTERNALADVICESELECT")
    private String policeExternalAdviceSelect;

    //实时姓名
    @TableField(value = "realtimeName")
    private String realtimeName;

    //实时身份证号
    @TableField(value = "realtimeDocumentID")
    private String realtimeDocumentID;

    //抓捕状态 已抓获1 ，未抓获0,处理中 2
    @TableField(value = "CAPTURESTATUS")
    private Integer captureStatus;

    //背筛次数
    @TableField(value = "screening_count")
    private Integer screeningCount;

}
