package com.bcxin.backend.configs;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Data
@Component
@ConfigurationProperties(prefix = "myapps.screening")
public class ScreeningConfig {

    //是否开启背景筛查
    private Boolean enable;

    //公安内网  api 开启背景筛查必须填写此项  当地公安内网的地址
    private String api;

    //业务中不同环境指定不同的server
    private String serverKey;

    //调度任务配置
    private Scheduled scheduled;


    //调度任务配置
    @Data
    public static class Scheduled{

        //定期背筛定时器隔
        private String timing;
        //定期背筛每次执行取值天数
        private Integer timingDay;
        //定期背筛每次执行数量
        private Integer timingCount;

        //新入职员工背筛定时器
        private String induction;
        //新入职员工背筛每次执行数量
        private Integer inductionCount;

    }

}
