package com.bcxin.obpm.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.exception.V5BusinessException;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.domain.SysInterfaceLog;
import com.bcxin.auth.system.mapper.SysInterfaceLogMapper;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.*;
import com.bcxin.obpm.dto.hunan.*;
import com.bcxin.obpm.service.BackgroundService;
import com.bcxin.obpm.util.AuthConstants;
import com.bcxin.obpm.util.FaceUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.ibatis.jdbc.Null;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;

import javax.annotation.Resource;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 湖南
 *
 * @author linqinglin
 * @date 2021/08/19 0019 10:24
 */
@Service("backgroundService_430000")
public class HNBackgroundServiceImpl implements BackgroundService {


    private static Logger logger = LoggerFactory.getLogger(HNBackgroundServiceImpl.class);

    @Autowired
    private ConfigUtil configUtil;

    @Resource
    private FaceUtil faceUtil;

    @Autowired
    private SysInterfaceLogMapper sysInterfaceLogMapper;

    /**
     * 湖南获取token
     *
     * @return {@link String}
     */
    public Token getToken() {
        Map<String, Object> params = Maps.newHashMap();
        params.put("client_id", AuthConstants.HUNAN_TOKEN_CLIENT_ID);
        params.put("client_secret", AuthConstants.HUNAN_TOKEN_CLIENT_SECRET);
        params.put("grant_type", AuthConstants.HUNAN_TOKEN_TYPE);
        params.put("type", AuthConstants.HUNAN_TOKEN_TYPE);
        params.put("sfzh", DigestUtils.md5DigestAsHex(AuthConstants.HUNAN_TOKEN_ID_NUMBER.getBytes()));
        String postResult = HttpUtil.post(AuthConstants.HUNAN_TOKEN_REQUEST_URL, params);
        return JSON.parseObject(postResult, Token.class);
    }

    /**
     * 获取人口库信息
     *
     * @param idNumber 身份证号
     * @return
     */
    @Override
    public AjaxResult getPersonnelInformation(String idNumber) {
        if (StringUtils.isEmpty(idNumber)) {
            return AjaxResult.error("参数不正确");
        }
        AuthenticationResult authenticationResult = new AuthenticationResult();
        // 设置身份证号
        authenticationResult.setIdNumber(idNumber);

        if (configUtil.isTest()) {
            return AjaxResult.success("请求成功", authenticationResult);
        }

        // 获取token
        Token token = this.getToken();
        logger.info("token:{}", token);
        // 请求人口信息
        Map<String, String> params = Maps.newHashMap();
        params.put("sfzh", idNumber);
        HttpRequest request = HttpUtil.createPost(AuthConstants.HUNAN_PEOPLE_INFO_REQUEST_URL);
        request.header(HttpHeaders.CONTENT_TYPE, "application/json;charset=UTF-8");
        request.bearerAuth(token.getAccessToken());
        request.body(JSONUtil.toJsonStr(params));
        HttpResponse response = request.execute();

        String peopleInfoBody = response.body();
        HuNanPeopleResult huNanPeopleResult = JSONUtil.toBean(peopleInfoBody, HuNanPeopleResult.class);
        logger.info("{}人口库返回:{}", idNumber, huNanPeopleResult);
        List<HuNanPeopleInfo> data = huNanPeopleResult.getData();
        if (data != null && !data.isEmpty()) {
            HuNanPeopleInfo huNanPeopleInfo = data.get(0);
            authenticationResult.setRealName(huNanPeopleInfo.getXm());
        }
        // 请求照片服务
        HttpResponse photoResponse = HttpUtil.createGet(AuthConstants.HUNAN_PEOPLE_PHOTO_REQUEST_URL)
                .form("sfzh", idNumber)
                .form("access_token", token.getAccessToken())
                .execute();

        String photoBody = photoResponse.body();
        HuNanResult photoResult = JSONUtil.toBean(photoBody, HuNanResult.class);
        // 设置照片
        if (StrUtil.isNotEmpty(photoResult.getData())) {
            authenticationResult.setPhoto(photoResult.getData());
        }
        logger.info("{}人员信息服务返回:{}", idNumber, authenticationResult);
        return AjaxResult.success("请求成功", authenticationResult);
    }

    /**
     * 实名认证比对
     *
     * @param list
     * @return List<AuthLog>
     */
    @Override
    public List<AuthLog> validateResult(List<AuthLog> list) {
        Map<String, PerPhotoDto> personMap = getPopulationInfo(list);
        for (AuthLog authLog : list) {
            try {
                /***2.2 获取人口库照片，base64，如果是互联网则获取本地图片，以身份证命名******/
                PerPhotoDto person = personMap.get(authLog.getIdNumber());
                String xp = "";
                /**
                 *  2.2.1获取姓名
                 */
                String name = person.getName();
                /**
                 * 2.2.2 判断姓名是否为空，如果为空，则人口库没有信息
                 */
                if (StrUtil.isEmpty(name)) {
                    //姓名和身份证不匹配
                    authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                    authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_CARD_IDEMSG);
                } else if (name.equals(authLog.getSecurityName())) {
                    /**
                     * 2.2.3 匹配姓名是否正常，如果匹配则获取照片信息，不匹配则返回
                     */
                    //获取人口库照片
                    xp = person.getPhoto();
                    /***2.2.4 没有照片代码身份证和姓名不匹配**/
                    if (StrUtil.isEmpty(xp)) {
                        authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                        authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_PHOTO_IDEMSG);
                    }
                } else {
                    /***
                     * 2.2.4 姓名和身份证不匹配
                     */
                    authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                    authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_NAME_IDEMSG);
                }

                /***
                 * 2.3 如果有照片进行对比
                 */
                if (StrUtil.isNotEmpty(xp)) {
                    /***2.4 人口库和认证头像比对 **/
                    if (xp.trim().startsWith("http")) {
                        logger.error("在线地址转base64");
                        String suffix = ".jpg";
                        if (!xp.matches(".*access_token.*")) {
                            suffix = xp.substring(xp.lastIndexOf("."));
                        }
                        String filePath = BMSConfig.getTempPath() + UUID.randomUUID().toString() + suffix;
                        faceUtil.downloadFile(xp, filePath);
                        xp = faceUtil.ImageToBase64(filePath);
                        FileUtil.del(filePath);
                    }

                    if (faceUtil.matchResult(xp, faceUtil.ImageToBase64(authLog.getImgPath()))) {
                        authLog.setAuthStatus(AuthConstants.AUTHRESULT_YES);
                        authLog.setAuthResult(AuthConstants.AUTHRESULT_YES_MESSAGE);
                    } else {
                        authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                        authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_IMGMSG);
                    }
                }
                authLog.setAuthDate(DateUtils.getNowDate());
            } catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), e);
            }
        }
        return list.stream().filter(((authLog) -> StrUtil.isNotEmpty(authLog.getAuthStatus()))).collect(Collectors.toList());
    }

    @Override
    public void getPersonnelAddress(String idNumber) {

    }

    /**
     * 实名认证比对 获取人口库信息
     *
     * @param idnum
     * @return PerPhotoDto
     */
    private PerPhotoDto getPopulationInfo(String idnum) {
        PerPhotoDto perPhotoDto = new PerPhotoDto();
        SysInterfaceLog interfaceLog=new SysInterfaceLog();
        Boolean isSuccessful = true;
        // 设置身份证号
        perPhotoDto.setIdNum(idnum);
        // 获取token
        Token token = getToken();
        logger.error("token:{}", token);
        // 请求人口信息
        Map<String, String> params = Maps.newHashMap();
        params.put("sfzh", idnum);
        logger.error("请求地址:{}", AuthConstants.HUNAN_PEOPLE_INFO_REQUEST_URL);
        logger.error("请求参数:{}", JSONUtil.toJsonStr(params));
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(AuthConstants.HUNAN_PEOPLE_INFO_REQUEST_URL);
        interfaceLog.setParameters(JSONUtil.toJsonStr(params));
        HttpRequest request = HttpUtil.createPost(AuthConstants.HUNAN_PEOPLE_INFO_REQUEST_URL);
        request.header(HttpHeaders.CONTENT_TYPE, "application/json;charset=UTF-8");
        request.bearerAuth(token.getAccessToken());
        request.body(JSONUtil.toJsonStr(params));
        HttpResponse response = request.execute();
        String peopleInfoBody = response.body();
        HuNanPeopleResult huNanPeopleResult = JSONUtil.toBean(peopleInfoBody, HuNanPeopleResult.class);
        logger.error("{}人口库返回:{}", idnum, huNanPeopleResult);
        List<HuNanPeopleInfo> data = huNanPeopleResult.getData();
        if (data != null && !data.isEmpty()) {
            HuNanPeopleInfo huNanPeopleInfo = data.get(0);
            perPhotoDto.setName(huNanPeopleInfo.getXm());

            // 请求照片服务
            logger.error("人员信息服务地址:{}", AuthConstants.HUNAN_PEOPLE_PHOTO_REQUEST_URL);
            HttpResponse photoResponse = HttpUtil.createGet(AuthConstants.HUNAN_PEOPLE_PHOTO_REQUEST_URL)
                    .form("sfzh", idnum)
                    .form("access_token", token.getAccessToken())
                    .execute();

            String photoBody = photoResponse.body();
            logger.error("{}人员信息服务返回:{}", idnum, photoBody);
            HuNanResult photoResult = JSONUtil.toBean(photoBody, HuNanResult.class);
            // 设置照片
            if (StrUtil.isNotEmpty(photoResult.getData())) {
                perPhotoDto.setPhoto(photoResult.getData());
            }
        }
        interfaceLog.setResult(perPhotoDto.toString());
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(isSuccessful);
        new Thread(()->{
            sysInterfaceLogMapper.insert(interfaceLog);
        }).start();
        return perPhotoDto;
    }

    /**
     * 实名认证比对 获取人口库信息
     *
     * @param authLogList
     * @return
     */
    public Map<String, PerPhotoDto> getPopulationInfo(List<AuthLog> authLogList) {
        Map<String, PerPhotoDto> personList = new HashMap<>();
        PerPhotoDto person = null;
        for (AuthLog authLog : authLogList) {
            person = getPopulationInfo(authLog.getIdNumber());
            if (person != null) {
                personList.put(person.getIdNum(), person);
            }
        }

        return personList;
    }

    /**
     * 背景筛查
     *
     * @param idNumber 身份证
     * @param realName
     * @return
     */
    @Override
    public AjaxResult personnelReview(String idNumber, String realName) {
        if (StringUtils.isEmpty(idNumber)) {
            return AjaxResult.error("参数不正确");
        }
        BackgroundResult backgroundResult = new BackgroundResult();
        backgroundResult.setIdNumber(idNumber);

        if (configUtil.isTest()) {
            return AjaxResult.success("请求成功");
        }
        //查询是否是吸毒人员
        //BackgroundInfo isDrug = getInformationOnDrugPersonnel(idNumber);
        //查询是否是拘留人员
        //BackgroundInfo isDetention=getInformationOnDetentionPersonnel(idNumber);
        //查询是否是看守所出所人员
        //BackgroundInfo isJail=getInformationOnJailPersonnel(idNumber);
        //查询是否是在逃人员
        //BackgroundInfo isLarge=getInformationOnLargePersonnel(idNumber);
        //查询是否是违法行为人员
        //BackgroundInfo isOffenders=getInformationOnOffendersPersonnel(idNumber);
        List<BackgroundInfo> backgroundInfoList = new ArrayList<>();
        //判断是否是问题人员，是问题人员才进行数据返回
        /*if (StringUtils.isNotEmpty(isDrug.getData())){
            backgroundInfoList.add(isDrug);
        }
        if (StringUtils.isNotEmpty(isDetention.getData())){
            backgroundInfoList.add(isDetention);
        }
        if (StringUtils.isNotEmpty(isJail.getData())){
            backgroundInfoList.add(isJail);
        }
        if (StringUtils.isNotEmpty(isLarge.getData())){
            backgroundInfoList.add(isLarge);
        }
        if (StringUtils.isNotEmpty(isOffenders.getData())){
            backgroundInfoList.add(isOffenders);
        }*/
        backgroundResult.setCensorResult(backgroundInfoList);
        logger.info("身份证{}筛查结果:{}", idNumber, backgroundResult);
        // 请求
        return AjaxResult.success("请求成功", backgroundResult);
    }


    private HuNanResponseInfo getResponseResult(String sender_id, String service_id, String postURL,String idNumber,boolean isEscaped) {
        //链式构建请求
        String returnValue = StringUtils.EMPTY;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HuNanResponseInfo huNanResponseInfo=new HuNanResponseInfo();
        ResponseHandler<String> responseHandler = new BasicResponseHandler();
        String timestamp=new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        try {
            //第一步：创建HttpClient对象
            httpClient = HttpClients.createDefault();
            //第二步：创建httpPost对象
            HttpPost httpPost = new HttpPost(postURL);
            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(Constants.TIMEOUT);
            requestConfig.setConnectionRequestTimeout(Constants.TIMEOUT);
            requestConfig.setSocketTimeout(Constants.TIMEOUT);
            //第三步：给httpPost设置JSON格式的参数
            String data = getRequestFrom(idNumber,isEscaped);
            StringEntity requestEntity = new StringEntity(data, "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            System.out.println(requestEntity);
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            //请求方Id
            httpPost.setHeader("senderid",sender_id);
            //服务方Id
            httpPost.setHeader("serviceid",service_id);
            //终端访问用户姓名
            httpPost.setHeader("bus_sre_name",AuthConstants.HUNAN_BACKGROUND_END_USER_NAME);
            //终端访问用户身份标识号码
            httpPost.setHeader("end_user.id_card",AuthConstants.HUNAN_BACKGROUND_END_USER_ID_CARD);
            //终端访问用户所在单位
            httpPost.setHeader("end_user.department",AuthConstants.HUNAN_BACKGROUND_END_USER_DEPARTMENT);
            //终端访问用户数字证书编号
            httpPost.setHeader("end_user.certificate",AuthConstants.HUNAN_BACKGROUND_END_USER_CERTIFICATE);
            //终端标识可以是pc的ip或者移动设备的mac
            httpPost.setHeader("end_user.device_id",AuthConstants.HUNAN_BACKGROUND_END_USER_DEVICE_ID);
            //超时时间
            httpPost.setHeader("timeout",AuthConstants.HUNAN_BACKGROUND_TIME_OUT);
            //请求方发出请求的时间点
            httpPost.setHeader("timestamp",timestamp);
            httpPost.setConfig(requestConfig.build());
            httpPost.setEntity(requestEntity);
            //第四步：发送HttpPost请求，获取返回值
            returnValue = httpClient.execute(httpPost, responseHandler);
            JSONObject object = JSONObject.parseObject(returnValue);
            logger.error("湖南新背景筛查身份证:"+idNumber+"返回结果:"+object.toJSONString());
            huNanResponseInfo=JSONObject.parseObject(returnValue,HuNanResponseInfo.class);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("背景筛查接口异常"+e.getMessage());
            throw new V5BusinessException(e.getMessage());
        } finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return huNanResponseInfo;
    }

        /*组装请求的body参数*/
    private String getRequestFrom(String idNumber,boolean isEscaped) {
        Map<String, Object> requestForm = Maps.newHashMap();
        requestForm.put("httpMethod","GET");
        Map<String, Object> executeSource = Maps.newHashMap();
        Map<String, Object> query = Maps.newHashMap();
        Map<String, Object> term = Maps.newHashMap();
        Map<String, Object> keyword = Maps.newHashMap();
        keyword.put("value",idNumber);
        String key="zjhm.keyword";
        if (isEscaped){
            key="gmsfzh.keyword";
        }
        term.put(key,keyword);
        query.put("term",term);
        executeSource.put("query",query);
        requestForm.put("executeSource",executeSource);
        return JSONUtil.toJsonStr(JSONUtil.parse(requestForm));
    }

    /**
     * 湖南省公安厅省厅_监管_戒毒所人员信息通用数据查询
     *
     * @param idNumber    身份证号
     * @return {@link BackgroundInfo} 是否吸毒人员
     */
    public BackgroundInfo getInformationOnDrugPersonnel(String idNumber) {
        logger.error("jds人员信息通用数据查询-----------------------------");
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String sender_id=AuthConstants.HUNAN_BACKGROUND_SENDER_ID;
        String service_id=AuthConstants.HUNAN_BACKGROUND_SERVICE_ID_XD;
        String postURL=AuthConstants.HUNAN_BACKGROUND_NEW_URL;
        try {
            HuNanResponseInfo huNanResponseInfo = getResponseResult(sender_id, service_id, postURL,idNumber,false);
            if (StringUtils.isNotNull(huNanResponseInfo.getHits())&&
                    StringUtils.isNotNull(huNanResponseInfo.getHits().getTotal())&&
                    huNanResponseInfo.getHits().getTotal().getValue()!=0){
                    Map<String, Object> wfMap = new HashMap<>();
                    wfMap.put("detail","戒毒所人员");
                    backgroundInfo.setCode(200);
                    backgroundInfo.setCxxt("省厅_监管_戒毒所人员信息");
                    backgroundInfo.setData(wfMap);
                    //1 问题人眼 0 正常人员
                    backgroundInfo.setResult(1);
           }
        }catch (Exception e){
            throw new V5BusinessException("jds人员信息接口调用异常",e);
        }

        return backgroundInfo;
    }

    /**
     * 湖南省公安厅省厅_监管_拘留所人员信息通用数据查询
     *
     * @param idNumber    身份证号
     * @return {@link BackgroundInfo} 是否拘留人员
     */
    public BackgroundInfo getInformationOnDetentionPersonnel(String idNumber) {
logger.error("jls人员信息通用数据查询-----------------------------");
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String sender_id=AuthConstants.HUNAN_BACKGROUND_SENDER_ID;
        String service_id=AuthConstants.HUNAN_BACKGROUND_SERVICE_ID_JL;
        String postURL=AuthConstants.HUNAN_BACKGROUND_NEW_URL;
        try {
            HuNanResponseInfo huNanResponseInfo = getResponseResult(sender_id, service_id, postURL,idNumber,false);
            if (StringUtils.isNotNull(huNanResponseInfo.getHits())&&
                    StringUtils.isNotNull(huNanResponseInfo.getHits().getTotal())&&
                    huNanResponseInfo.getHits().getTotal().getValue()!=0) {
                Map<String, Object> wfMap = new HashMap<>();
                wfMap.put("detail","拘留所人员");
                backgroundInfo.setCode(200);
                backgroundInfo.setCxxt("省厅_监管_拘留所人员信息");
                backgroundInfo.setData(wfMap);
                //1 问题人眼 0 正常人员
                backgroundInfo.setResult(1);
            }
        }catch (Exception e){
            throw new V5BusinessException("jls人员信息接口调用异常",e);
        }
        return backgroundInfo;
    }

    /**
     * 湖南省公安厅省厅_监管_看守所出所人员通用数据查询
     *
     * @param idNumber    身份证号
     * @return {@link BackgroundInfo} 是否看守所出所人员
     */
    public BackgroundInfo getInformationOnJailPersonnel(String idNumber) {
logger.error("bjg人员通用数据查询-----------------------------");
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String sender_id=AuthConstants.HUNAN_BACKGROUND_SENDER_ID;
        String service_id=AuthConstants.HUNAN_BACKGROUND_SERVICE_ID_KS;
        String postURL=AuthConstants.HUNAN_BACKGROUND_NEW_URL;
        try {
            HuNanResponseInfo huNanResponseInfo = getResponseResult(sender_id, service_id, postURL,idNumber,false);
            if (StringUtils.isNotNull(huNanResponseInfo.getHits())&&
                    StringUtils.isNotNull(huNanResponseInfo.getHits().getTotal())&&
                    huNanResponseInfo.getHits().getTotal().getValue()!=0) {
                Map<String, Object> wfMap = new HashMap<>();
                wfMap.put("detail","被监管人员");
                backgroundInfo.setCode(200);
                backgroundInfo.setCxxt("省厅_监管_被监管人员信息");
                backgroundInfo.setData(wfMap);
                //1 问题人眼 0 正常人员
                backgroundInfo.setResult(1);
            }
        }catch (Exception e){
            throw new V5BusinessException("bjg人员信息接口调用异常",e);
        }
        return backgroundInfo;
    }
    /**
     * 湖南省公安厅省厅_刑侦_全国在逃人员信息通用数据查询
     *
     * @param idNumber    身份证号
     * @return {@link BackgroundInfo} 是否全国在逃人员
     */
    public BackgroundInfo getInformationOnLargePersonnel(String idNumber) {
logger.error("zt人员信息通用数据查询-----------------------------");
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String sender_id=AuthConstants.HUNAN_BACKGROUND_SENDER_ID;
        String service_id=AuthConstants.HUNAN_BACKGROUND_SERVICE_ID_ZT;
        String postURL=AuthConstants.HUNAN_BACKGROUND_NEW_URL;
        try {
            HuNanResponseInfo huNanResponseInfo = getResponseResult(sender_id, service_id, postURL,idNumber,true);
            if (StringUtils.isNotNull(huNanResponseInfo.getHits())&&
                    StringUtils.isNotNull(huNanResponseInfo.getHits().getTotal())&&
                    huNanResponseInfo.getHits().getTotal().getValue()!=0) {
                     Map<String, Object> wfMap = new HashMap<>();
                    wfMap.put("detail", "全国在逃人员");
                    backgroundInfo.setCode(200);
                    backgroundInfo.setCxxt("省厅_刑侦_全国在逃人员");
                    backgroundInfo.setData(wfMap);
                    //1 问题人眼 0 正常人员
                    backgroundInfo.setResult(1);
            }
        }catch (Exception e){
            throw new V5BusinessException("zt人员信息接口调用异常",e);
        }
        return backgroundInfo;
    }

    /**
     * 湖南省公安厅省厅_刑侦_违法行为人信息通用数据查询
     *
     * @param idNumber    身份证号
     * @return {@link BackgroundInfo} 是否违法人员
     */
    public BackgroundInfo getInformationOnOffendersPersonnel(String idNumber) {
        logger.error("wf人信息通用数据查询-----------------------------");
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String sender_id=AuthConstants.HUNAN_BACKGROUND_SENDER_ID;
        String service_id=AuthConstants.HUNAN_BACKGROUND_SERVICE_ID_WF;
        String postURL=AuthConstants.HUNAN_BACKGROUND_NEW_URL;
        try {
            HuNanResponseInfo huNanResponseInfo = getResponseResult(sender_id, service_id, postURL,idNumber,false);
            if (StringUtils.isNotNull(huNanResponseInfo.getHits())&&
                    StringUtils.isNotNull(huNanResponseInfo.getHits().getTotal())&&
                    huNanResponseInfo.getHits().getTotal().getValue()!=0) {
                Map<String, Object> wfMap = new HashMap<>();
                wfMap.put("detail","违法行为人员");
                backgroundInfo.setCode(200);
                backgroundInfo.setCxxt("省厅_法制_执法办案违法行为人员");
                backgroundInfo.setData(wfMap);
                //1 问题人眼 0 正常人员
                backgroundInfo.setResult(1);
            }
        }catch (Exception e){
            throw new V5BusinessException("wf人员信息接口调用异常",e);
        }
        return backgroundInfo;
    }


    public static void main(String[] args) {
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String  returnValue = "{\n" +
                "    \"_shards\":{\n" +
                "        \"total\":5,\n" +
                "        \"failed\":0,\n" +
                "        \"successful\":5,\n" +
                "        \"skipped\":0\n" +
                "    },\n" +
                "    \"hits\":{\n" +
                "        \"hits\":[\n" +
                "\n" +
                "        ],\n" +
                "        \"total\":{\n" +
                "            \"value\":3,\n" +
                "            \"relation\":\"eq\"\n" +
                "        },\n" +
                "        \"max score\":12.2652025\n" +
                "    },\n" +
                "    \"took\":35,\n" +
                "    \"timed out\":false\n" +
                "}";
        try {
            HuNanResponseInfo huNanResponseInfo=JSONObject.parseObject(returnValue,HuNanResponseInfo.class);
            if (StringUtils.isNotNull(huNanResponseInfo.getHits())&&
                    StringUtils.isNotNull(huNanResponseInfo.getHits().getTotal())&&
                    huNanResponseInfo.getHits().getTotal().getValue()!=0) {
                Map<String, Object> wfMap = new HashMap<>();
                wfMap.put("detail","违法行为人员(刑侦)");
                backgroundInfo.setCode(200);
                backgroundInfo.setCxxt("湖南刑侦_违法行为人员信息");
                backgroundInfo.setData(wfMap);
                //1 问题人眼 0 正常人员
                backgroundInfo.setResult(1);
            }
        }catch (Exception e){
            throw new V5BusinessException("违法行为人员信息接口调用异常",e);
        }
        System.out.println(backgroundInfo.toString());
    }

}
