package com.bcxin.obpm.dto.Ministerial;


import com.bcxin.obpm.annotation.MinisterialAttr;
import com.bcxin.obpm.annotation.MinisterialEntity;
import lombok.Data;

/**
 * 保安从业单位及保安培训机构监督检查被处理人基本信息
 *
 * @author llc
 */
@Data
@MinisterialEntity(tableName = "tlk_emplpunish")
public class Badwjdjcbclrxx extends XxbaBaseDto {
    /**
     * 保安单位编码
     */
    @MinisterialAttr(column = "(select item_companyCode from tlk_companyinformation sc where sc.DOMAINID = t1.DOMAINID and sc.ITEM_companyName=t1.ITEM_BELONGCOMPANYNAME  limit 1)", isSubQuery = true)
    private String bagsbm;
    /**
     * 检查日期
     */
    @MinisterialAttr(column = "ITEM_COMMENDATIONREWARDTIME", DATE_FORMAT = "%Y%m%d")
    private String jcrq;
    /**
     * 被检查单位类型
     */
    @MinisterialAttr(column = "(select item_officeType from tlk_companyinformation sc where sc.DOMAINID = t1.DOMAINID and sc.ITEM_companyName=t1.ITEM_BELONGCOMPANYNAME  limit 1)", isSubQuery = true, DATA_FORMAT = MinisterialDataFormat.INSTITUTION_TYPE)
    private String jclx;
    /**
     * 被处理人员身份号码
     */
    @MinisterialAttr(column = "ITEM_USERDOCUMENTID")
    private String sfzh;
    /**
     * 被处理人职务
     */
    private String zw;
    /**
     * 处理结果
     */
    private String cljg;
    /**
     * 罚款金额
     */
    private String fkje;
    /**
     * 没收违法所得金额
     */
    private String mswfsdje;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;


    @Override
    public String toString() {
        return "Badwjdjcbclrxx{" +
                "bagsbm='" + bagsbm + '\'' +
                ", jcrq='" + jcrq + '\'' +
                ", jclx='" + jclx + '\'' +
                ", sfzh='" + sfzh + '\'' +
                ", zw='" + zw + '\'' +
                ", cljg='" + cljg + '\'' +
                ", fkje='" + fkje + '\'' +
                ", mswfsdje='" + mswfsdje + '\'' +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                '}';
    }
}
