package com.bcxin.platform.util.v5;


import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.concurrent.TimeUnit;

@Slf4j
public class BcxinHttpUtil {

	/**
	 * POST方式调用
	 *
	 * @param url
	 * @param params
	 *            参数为NameValuePair键值对对象
	 * @return 响应字符串
	 * @throws java.io.UnsupportedEncodingException
	 */
	public static String sendPostRequest(String url, List<NameValuePair> params) {
		log.debug("--------开始发送http请求--------");
		log.debug("请求地址:[{}]：",url);
		logParams(params);
		Stopwatch stopwatch = Stopwatch.createStarted();
		String result = "";
		try (CloseableHttpClient httpClient = HttpClients.createDefault()){
			HttpPost httpPost = new HttpPost(url);
			RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(1000)
					.setSocketTimeout(1000).setConnectTimeout(1000).build();
			httpPost.setConfig(requestConfig);
			httpPost.setEntity(new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
			try (CloseableHttpResponse resp = httpClient.execute(httpPost)) {
				HttpEntity entity = resp.getEntity();
				result = EntityUtils.toString(entity, StandardCharsets.UTF_8);
				long nanos = stopwatch.elapsed(TimeUnit.MILLISECONDS);
				log.debug("返回结果：[{}]", result);
				log.debug("共耗时[{}]毫秒：" , nanos);
				log.debug("--------结束http请求--------");
			}
		} catch (IOException ex) {
			ex.printStackTrace();
		}
		return result;
	}


	/**
	 * POST方式调用
	 *
	 * @param url
	 * @param obj
	 *            参数为NameValuePair键值对对象
	 * @return 响应字符串
	 */
	public static String sendPostRequest(String url,Map<String , String> bdpConfigMap, Object obj) {
		log.debug("--------开始发送http请求--------");
		log.debug("请求地址:[{}]：",url);
		log.debug("--------开始发送http请求--------");
		log.debug("请求地址:[{}]：",url);
		Stopwatch stopwatch = Stopwatch.createStarted();
		String result = "";
		try (CloseableHttpClient httpClient = HttpClients.createDefault()){
			String authString = String.format("%s:%s",bdpConfigMap.get("clientId"), bdpConfigMap.get("secret"));
			String authStringEnc = Base64.getEncoder().encodeToString(authString.getBytes(StandardCharsets.UTF_8));
			HttpPost httpPost = new HttpPost(url);
			RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(1000)
					.setSocketTimeout(1000).setConnectTimeout(1000).build();
			httpPost.setConfig(requestConfig);
			httpPost.setHeader("Authorization", String.format("Basic %s", authStringEnc));
			httpPost.setHeader("Content-Type", "application/json");
			JSONObject body = new JSONObject();
			body.put("routeKey", "");
			//直接推送数据的方式
			body.put("messageType", 1);
			body.put("protocol",0);
			body.put("topicProducerId",bdpConfigMap.get("id"));
			body.put("data", obj);
			StringEntity stringEntity = new StringEntity(JSONObject.toJSONString(body, SerializerFeature.WriteMapNullValue),"UTF-8");
			httpPost.setEntity(stringEntity);
			try (CloseableHttpResponse resp = httpClient.execute(httpPost)) {
				HttpEntity entity = resp.getEntity();
				result = EntityUtils.toString(entity, StandardCharsets.UTF_8);
				long nanos = stopwatch.elapsed(TimeUnit.MILLISECONDS);
				log.debug("返回结果：[{}]", result);
				log.debug("共耗时[{}]毫秒：" , nanos);
				log.debug("--------结束http请求--------");
			}
		} catch (IOException ex) {
			ex.printStackTrace();
		}
		return result;
	}

	/**
	 * POST方式调用
	 *
	 * @param url
	 * @param params
	 *            参数为NameValuePair键值对对象
	 * @return 响应字符串
	 * @throws java.io.UnsupportedEncodingException
	 */
	public static String sendTianLingPostRequest(String url, Map<String,String> params) {
		log.debug("--------开始发送http请求--------");
		log.debug("请求地址:[{}]：",url);
		List<NameValuePair> pairList = Lists.newArrayList();
		if (MapUtil.isNotEmpty(params)) {
			Iterator iterator = params.entrySet().iterator();
			while(iterator.hasNext()){
				Map.Entry<String,String> elem = (Map.Entry<String, String>) iterator.next();
				pairList.add(new BasicNameValuePair(elem.getKey(),elem.getValue()));
			}
		}
		return sendPostRequest(url,pairList);
	}


	/**
	 * POST方式调用
	 *
	 * @param url
	 * @param params
	 *            参数为NameValuePair键值对对象
	 * @return 响应字符串
	 * @throws java.io.UnsupportedEncodingException
	 */
	public static String sendPostRequestObj(String url, Map<String,Object> params) {
		log.debug("--------开始发送http请求--------");
		log.debug("请求地址:[{}]：",url);
		List<NameValuePair> pairList = Lists.newArrayList();
		if (MapUtil.isNotEmpty(params)) {
			Iterator iterator = params.entrySet().iterator();
			while(iterator.hasNext()){
				Map.Entry<String,Object> elem = (Map.Entry<String, Object>) iterator.next();
				pairList.add(new BasicNameValuePair(elem.getKey(),elem.getValue() == null ? "":elem.getValue().toString()));
			}
		}
		return sendPostRequest(url,pairList);
	}


	/**
	 * 获取请求参数中所有的信息
	 * @param request
	 * @return
	 */
	public static Map<String, String> getAllRequestParam(HttpServletRequest request) {
		Map<String, String> res = new HashMap<String, String>();
		Enumeration<?> temp = request.getParameterNames();
		if (null != temp) {
			while (temp.hasMoreElements()) {
				String en = (String) temp.nextElement();
				String value = request.getParameter(en);
				res.put(en, value);
				//在报文上送时，如果字段的值为空，则不上送<下面的处理为在获取所有参数数据时，判断若值为空，则删除这个字段>
				//System.out.println("ServletUtil类247行  temp数据的键=="+en+"     值==="+value);
				if (null == res.get(en) || "".equals(res.get(en))) {
					res.remove(en);
				}
			}
		}
		return res;
	}




	private static void logParams(List<NameValuePair> params){
		for(NameValuePair pair:params){
			log.debug("请求的参数名：[{}]，值：[{}]",pair.getName(),pair.getValue());
		}
	}
}
