package com.bcxin.platform.util.map;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.util.HttpUtils;
import org.apache.http.NameValuePair;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.*;

public class GaodeMapUtil {

    /**
     * 高德地图请求秘钥
     */
    private static final String KEY = "b005b544c167cbb933edf53a0ab46e5f";
    /**
     * 返回值类型
     */
    private static final String OUTPUT = "JSON";
    /**
     * 根据地名获取高德经纬度
     */
    private static final String GET_LNG_LAT_URL = "http://restapi.amap.com/v3/geocode/geo";
    /**
     * 根据高德经纬度获取地名
     */
    private static final String GET_ADDRESS_URL = "http://restapi.amap.com/v3/geocode/regeo";

    /**
     * 根据两点位置获取距离
     */
    private static final String GET_DISTANCE = "http://restapi.amap.com/v3/distance";

    /**
     * 根据高德经纬度获取地址信息
     *
     * @param gdLon 高德地图经度
     * @param gdLat 高德地图纬度
     * @return
     */
    public static String getAddressByLonLat(double gdLon, double gdLat) {

        String location = gdLon + "," + gdLat;
        Map<String, Object> params = new HashMap<>();
        params.put("location", location);

        // Map<String, String> result = new HashMap<>();
        try {
            // 拼装url
            String url = jointUrl(params, OUTPUT, KEY, GET_ADDRESS_URL);
            // 调用高德SDK
            return HttpUtils.doPost(url, params);
            // 解析Json字符串,获取城市名称
            // JSONObject jsonObject = JSON.parseObject(jsonResult);
            // String regeocode = jsonObject.getString("regeocode");
            // JSONObject regeocodeObj = JSON.parseObject(regeocode);
            // String address = regeocodeObj.getString("formatted_address");
            // 组装结果
            // result.put(location, address);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 根据地址信息获取高德经纬度
     *
     * @param address 地址信息
     * @return
     */
    public static String getLonLarByAddress(String address) {
        Map<String, Object> params = new HashMap<>();
        params.put("address", address);
        try {
            /*** 拼装url ***/
            String url = jointUrl(params, OUTPUT, KEY, GET_LNG_LAT_URL);
            /*** 调用高德地图SDK ***/
            String jsonResult =  HttpUtils.doPost(url, params);

            /*** 解析JSON字符串,取到高德经纬度  ***/
             JSONObject jsonObject = JSON.parseObject(jsonResult);
             if(ObjectUtil.equal(jsonObject.get("status"),"1")) {

                 JSONArray geocodes = jsonObject.getJSONArray("geocodes");
                 String geocode = JSON.toJSONString(geocodes.get(0));
                 JSONObject geocodeObj = JSON.parseObject(geocode);
                 String lonAndLat = geocodeObj.getString("location");
                 // 组装结果
                 Map<String, String> resultMap = new HashMap<>();
                 if (StringUtils.isNotEmpty(lonAndLat) && lonAndLat.contains(",")) {
                     String[] lonAndLatArr = lonAndLat.split(",");
                     resultMap.put("经度", lonAndLatArr[0]);
                     resultMap.put("纬度", lonAndLatArr[1]);
                     return resultMap.toString();
                 } else {
                     return "经纬度获取异常";
                 }
             }else{
                 return "接口调用异常";
             }
        } catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    /**
     * 拼接请求字符串
     *
     * @param params
     * @param output
     * @param key
     * @param url
     * @return
     * @throws IOException
     */
    private static String jointUrl(Map<String, Object> params, String output, String key, String url) throws IOException {
        StringBuilder baseUrl = new StringBuilder();
        baseUrl.append(url);

        int index = 0;
        Set<Map.Entry<String, Object>> entrys = params.entrySet();
        for (Map.Entry<String, Object> param : entrys) {
            // 判断是否是第一个参数
            if (index == 0) {
                baseUrl.append("?");
            } else {
                baseUrl.append("&");
            }
            baseUrl.append(param.getKey()).append("=").append(URLEncoder.encode(param.getValue().toString(), "utf-8"));
            index++;
        }
        baseUrl.append("&output=").append(output).append("&key=").append(key);

        return baseUrl.toString();
    }

    public static String getDistance(String startLonLat, String endLonLat){

        List<NameValuePair> params = new ArrayList<>();
        String jsonResult = "";
        try {
            /*** 拼装url ***/
            String url = GET_DISTANCE + "?key="+ KEY + "&type=1&origins="+startLonLat+"&destination="+endLonLat;
            /*** 调用高德地图SDK ***/
             jsonResult =  HttpUtils.doGet(url, params);

            /*** 解析JSON字符串,取到高德经纬度  ***/
            JSONObject jsonObject = JSON.parseObject(jsonResult);
            if(ObjectUtil.equal(jsonObject.get("status"),"1")) {
                return jsonObject.get("results").toString();
            }else{
                return Result.ERROR;
            }
        } catch (Exception e) {
            return Result.ERROR;
        }
    }


    public static void main(String[] args) throws IOException {
//        String result = getLonLarByAddress("百川信(厦门)网络技术有限公司");
//        String result = getAddressByLonLat(118.051962,24.607029);
        String result = getDistance("116.365607,39.906509|116.323814,39.947207","116.479996,39.985572");
        System.out.println(result);//经度
    }




}
