package com.bcxin.platform.service.product;


import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.product.ProductCoupon;
import com.bcxin.platform.dto.product.ProductCouponDownloadDto;
import com.bcxin.platform.dto.product.ProductCouponDto;

import java.util.List;

/**
 * 产品优惠券
 *
 * @author llc
 * @date 2020-12-16
 */
public interface ProductCouponService {

    /**
     * 校验优惠券
     * @return
     * @author llc
     * @date 2020-01-15
     */
    Result checkProductCoupon(ProductCoupon productCoupon) throws V5BusinessException;


    /**
     * 查询产品优惠券
     *
     * @param productCouponId 产品优惠券ID
     * @return 产品优惠券
     */
    ProductCoupon selectProductCouponById(Long productCouponId);

    /**
     * 查询产品优惠券列表
     *
     * @param productCoupon 产品优惠券
     * @return 产品优惠券集合
     */
    List<ProductCouponDownloadDto> selectProductCouponList(ProductCouponDto productCoupon);


    /**
     * 编辑产品优惠券
     *
     * @param productCoupon 产品优惠券
     * @return 结果
     */
    int updateProductCoupon(ProductCoupon productCoupon);

    /**
     * 批量删除产品优惠券
     *
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteProductCouponByIds(String ids);

    /**
     * 删除产品优惠券信息
     *
     * @param productCouponId 产品优惠券ID
     * @return 结果
     */
    int deleteProductCouponById(Long productCouponId);

}