package com.bcxin.platform.service.company;

import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.PerBaseInfoDto;
import com.bcxin.platform.dto.attend.AttendPerDto;
import com.bcxin.platform.dto.company.PerInfoQueryDto;

import java.util.List;

/**
 * 人员基础信息Service接口
 * 
 * @author task
 * @date 2021-04-09
 */
public interface PerBaseInfoService{

    /**
     * 查询人员基础信息
     * 
     * @param perId 人员基础信息ID
     * @return 人员基础信息
     */
    PerBaseInfo selectPerBaseInfoById(Long perId);

    /**
     * 通过v5用户id查询
     * @param tlkPerId
     * @return
     */
    PerBaseInfo selectPerBaseInfoByTlkId(String tlkPerId);

    /**
     * 查询人员基础信息列表
     * 
     * @param perBaseInfo 人员基础信息
     * @return 人员基础信息集合
     */
    List<PerBaseInfo> selectPerBaseInfoList(PerBaseInfo perBaseInfo);

    /**
     * 新增人员基础信息
     * 
     * @param perBaseInfo 人员基础信息
     * @return 结果
     */
    int insertPerBaseInfo(PerBaseInfo perBaseInfo);

    /**
     * 修改人员基础信息
     * 
     * @param perBaseInfo 人员基础信息
     * @return 结果
     */
    int updatePerBaseInfo(PerBaseInfoDto perBaseInfo);

    /**
     * 批量删除人员基础信息
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deletePerBaseInfoByIds(String ids);

    /**
     * 删除人员基础信息信息
     * 
     * @param perId 人员基础信息ID
     * @return 结果
     */
    int deletePerBaseInfoById(Long perId);

    /**
     * 修改人员基础信息
     *
     * @param list 人员基础信息
     * @return 结果
     */
    int editBatch(List<PerBaseInfoDto> list);

    /**
     * 通过人员ID列表查询人员基础信息
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-04-15
     */
    Result getPerBaseInfoListByPerIds(PerBaseInfoDto dto);

    /**
     * 华为云会议人员信息查询
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-12-11
     */
    Result pageForhuaweiMeetPerInfo(PerInfoQueryDto dto);

    void saveBatch(List<PerBaseInfo> perBaseInfoList);

    List<PerBaseInfo> selectPerBaseInfoByTlkIds(List<String> tlkIds);

    List<PerBaseInfo> selectPerBaseInfoByPerIds(AttendPerDto searchDto);
}
