package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendDict;
import com.bcxin.platform.dto.attend.AttendDictDto;
import com.bcxin.platform.mapper.attend.AttendDictMapper;
import com.bcxin.platform.service.attend.AttendDictService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 类别Service业务层处理
 * 
 * @author lin
 * @date 2021-08-10
 */
@Service
@Transactional("transactionManager")
public class AttendDictServiceImpl implements AttendDictService{

    @Autowired
    private AttendDictMapper attendDictMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询类别
     * 
     * @param id 类别ID
     * @return 类别
     */
    @Override
    public AttendDict findById(Long id){
        return attendDictMapper.findById(id);
    }

    /**
     * 查询类别列表
     * 
     * @param attendDict 类别
     * @return 类别
     */
    @Override
    public List<AttendDictDto> selectList(AttendDictDto attendDict){
        return attendDictMapper.selectList(attendDict);
    }

    /**
     * 修改类别
     * 
     * @param attendDict 类别
     * @return 结果
     */
    @Override
    public int update(AttendDict attendDict){
        if(attendDict.getId() == null){
            attendDict.setCreateTime(DateUtils.getNowDate());
            attendDict.setId(idWorker.nextId());
            attendDict.setIsDelete(Constants.N);
        }else{
            AttendDict dbAttendDict = attendDictMapper.findById(attendDict.getId());
            BeanUtils.copyPropertiesIgnore(attendDict,dbAttendDict,true);
            BeanUtils.copyPropertiesIgnore(dbAttendDict,attendDict,false);
        }
        attendDict.setUpdateTime(DateUtils.getNowDate());
        return attendDictMapper.save(attendDict);
    }

    /**
     * 删除类别对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){
        return attendDictMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除类别信息
     * 
     * @param id 类别ID
     * @return 结果
     */
    @Override
    public int deleteById(Long id){
        return attendDictMapper.deleteById(id);
    }
}
