package com.bcxin.platform.mapper.insurance;

import com.bcxin.platform.common.utils.blb.InsPreservationDetailVo;
import com.bcxin.platform.domain.insurance.ComInsBootScheme;
import com.bcxin.platform.domain.insurance.ComOnlineInsPer;
import com.bcxin.platform.dto.excel.InsPerExcelBean;
import com.bcxin.platform.dto.excel.NotIncludedInsurancePerExcelBean;
import com.bcxin.platform.dto.excel.UnderWarrantyPerExcelBean;
import com.bcxin.platform.dto.excel.UninsuredPerExcelBean;
import com.bcxin.platform.dto.insurance.BLBComInfoDTO;
import com.bcxin.platform.dto.insurance.InsPerDTO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public interface ComOnlineInsPerMapper {
	int delete(Long insPerDetailId);

	int insert(ComOnlineInsPer record);

	int update(ComOnlineInsPer record);

	/**
	 * 批量插入再保人员息
	 */
	int insertBatchPerInfo(List<Map> list);

	/**
	 * 批量删除在保人员信息
	 */
	int delPerInfo(@Param("comInsId") String comInsId, @Param("list") List<Map> list);

	List<String> findTlkRelationIds(@Param("comId") String comId, @Param("list") List<Map> list);

	/**
	 * <b> 根据百联保订单id删除保单关联人员记录 </b>
	 * @author ZXF
	 * @create 2020/01/10 0010 16:50
	 * @version
	 * @注意事项 </b>
	 */
	int delPerByBlbOrderId(@Param("blbOrderId") String blbOrderId);

	/**
	 * <b> 根据线下订单id删除已关联的在保人员数据 </b>
	 * @author ZXF
	 * @create 2019/05/23 0023 15:42
	 * @version
	 * @注意事项 </b>
	 */
	int delXXPerInfo(@Param("comInsId") Long comInsId);

	/**
	 * 批量删除已过期线上线下保单关联的投保人员信息
	 */
	int delAllLosePerInfo();

	List<String> allLoseTlkRelationIds();

	/**
	 * 根据订单id和人员ID列表获取百联保Vo实体列表
	 * 已投保
	 */
	List<InsPreservationDetailVo> getBlbVoByPerIds(@Param("orderId") String orderId, @Param("list") List<Map> list);

	/**
	 * 根据订单id和在保未录入人员ID列表获取百联保Vo实体列表
	 * 已投保
	 */
	String getBlbVoByInsPerDetailIds(@Param("orderId") String orderId, @Param("list") List<Map> list);
	/**
	 * 根据订单id和人员ID列表获取百联保Vo实体列表
	 * 未投保
	 */
	List<InsPreservationDetailVo> getBlbVoByPerIdsWithNotOrder(@Param("orderId") String orderId, @Param("list") List<Map> list);

	/**
	 * 得到需要投保的人的信息
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/3/30 13:19
	 */
	String getInsingPerIds(@Param("comId") Long comId);

	/**
	 * 得到离职需要撤保的信息
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/3/30 13:20
	 */
	String getNoInsPerIds(@Param("comId") Long comId);

	/**
	 * 保存方案书
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:54
	 */
	int saveBootScheme(ComInsBootScheme comInsBootScheme);

	/**
	 * 获取线上人员参保列表
	 * 
	 * @param map
	 * @return
	 */
	List<Map> getOnlineInsPerList(Map map);

	/**
	 * <b> 根据条件查询未投保的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:43
	 * @version
	 * @注意事项 </b>
	 */
	List<Map> findUninsuredPerList(InsPerDTO dto);

	List<UninsuredPerExcelBean> exportUninsuredPerList(InsPerDTO dto);

	/**
	 * <b> 根据条件查询未投保的人员总数 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:43
	 * @version
	 * @注意事项 </b>
	 */
	Integer findUninsuredPerListCount(InsPerDTO dto);

	/**
	 * <b> 根据条件查询已过滤的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:43
	 * @version
	 * @注意事项 </b>
	 */
	List<Map> findFilterPerList(InsPerDTO dto);

	/**
	 * <b> 根据条件查询已投保的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:43
	 * @version
	 * @注意事项 </b>
	 */
	List<Map> findUnderWarrantyPerList(InsPerDTO dto);

	/**
	 * <b> 导出根据条件筛选已投保的人员信息 </b>
	 * @author ZXF
	 * @create 2020/05/26 0026 10:35
	 * @version
	 * @注意事项 </b>
	 */
	List<UnderWarrantyPerExcelBean> exportUnderWarrantyPerList(InsPerDTO dto);

	/**
	 * <b> 根据条件查询已投保的人员总数 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:43
	 * @version
	 * @注意事项 </b>
	 */
	Integer findUnderWarrantyPerListCount(InsPerDTO dto);

	/**
	 * <b> 根据条件查询已投保未录入的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:43
	 * @version
	 * @注意事项 </b>
	 */
	List<Map> findNotIncludedInsurancePerList(InsPerDTO dto);

	/**
	 * <b> 导出根据条件筛选已投保未录入的人员信息 </b>
	 * @author ZXF
	 * @create 2020/05/26 0026 10:22
	 * @version
	 * @注意事项 </b>
	 */
	List<NotIncludedInsurancePerExcelBean> exportNotIncludedInsurancePerList(InsPerDTO dto);

	/**
	 * <b> 根据条件查询已投保未录入的人员总数 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:43
	 * @version
	 * @注意事项 </b>
	 */
	Integer findNotIncludedInsurancePerListCount(InsPerDTO dto);

	/**
	 * <b> 查询在保人员离职人数 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:43
	 * @version
	 * @注意事项 </b>
	 */
	int findYIncumbencyPerCount(InsPerDTO dto);

	/**
	 * <b> 统计（人员类别=“普通保安员+武装押运人员”） </b>
	 * @author ZXF
	 * @create 2019/05/16 0016 16:00
	 * @version
	 * @注意事项 </b>
	 */
	List<Map> countUninsuredPerAndCom();

	/**
	 * <b> 统计（企业已离职人员在保数量） </b>
	 * @author ZXF
	 * @create 2019/05/21 0021 10:58
	 * @version
	 * @注意事项 </b>
	 */
	List<Map> countYIncumbencyPerAndCom();

	/**
	 * <b> 查询身份证存在重复的身份证 </b>
	 * @author ZXF
	 * @create 2019/05/17 0017 14:23
	 * @version
	 * @注意事项 </b>
	 */
	String findRepetitionIdCard(@Param("comInsId") Long comInsId, @Param("list") String[] list);

	/**
	 * <b> 查询姓名字段为空的身份证，每次500条 </b>
	 * @author ZXF
	 * @create 2020/01/06 0006 10:47
	 * @version
	 * @注意事项 </b>
	 */
	String findIdCardByEmptyName(@Param("m") int m, @Param("n") int n);

	/**
	 * <b> 新增百联保同步在保人员名称身份证信息到临时表 </b>
	 * @author ZXF
	 * @create 2020/01/06 0006 13:57
	 * @version
	 * @注意事项 </b>
	 */
	int saveTempInsPerName(@Param("list") List list);

	/**
	 * <b> 删除临时表数据 </b>
	 * @author ZXF
	 * @create 2020/01/06 0006 13:58
	 * @version
	 * @注意事项 </b>
	 */
	int deleteTempInsPerName();

	/**
	 * <b> 拿临时表信息对应修改在保人员的名称 </b>
	 * @author ZXF
	 * @create 2020/01/06 0006 13:59
	 * @version
	 * @注意事项 </b>
	 */
	int updateNameByIdCards();

	/**
	 * <b> excel导入的有效行更新到临时表 </b>
	 * @author ZXF
	 * @create 2020/01/16 0016 14:19
	 * @version
	 * @注意事项 </b>
	 */
	int saveTempBatchInsPerImport(@Param("list") List<Map<String, Object>> list, @Param("importBatchId") Long importBatchId);

	/**
	 * <b> 删除批次id对应的所有记录 </b>
	 * @author ZXF
	 * @create 2020/01/16 0016 14:28
	 * @version
	 * @注意事项 </b>
	 */
	int deleteTempBatchInsPerImport(@Param("importBatchId") Long importBatchId);

	/**
	 * <b> 根据批次Id统计错误信息行数 </b>
	 * @author ZXF
	 * @create 2020/01/16 0016 14:32
	 * @version
	 * @注意事项 </b>
	 */
	int countErrOrSuccessTempBatchInsPerImport(@Param("isSuccess") String isSuccess, @Param("importBatchId") Long importBatchId);

	/**
	 * <b> 校验导入的人员是否存在身份证重复 </b>
	 * @author ZXF
	 * @create 2020/01/16 0016 16:01
	 * @version
	 * @注意事项 </b>
	 */
	int checkIdCardNoRepeat(@Param("importBatchId") Long importBatchId);

	/**
	 * <b> 校验导入的人员是否已经在保 </b>
	 * @author ZXF
	 * @create 2020/01/19 0019 13:44
	 * @version
	 * @注意事项 </b>
	 */
	int checkIdCardNoInsurance(@Param("importBatchId") Long importBatchId, @Param("comId") Long comId);

	/**
	 * <b> 临时表中人员在该企业的所有保单中是否在保 </b>
	 * @author ZXF
	 * @create 2020/06/04 0004 16:15
	 * @version
	 * @注意事项 </b>
	 */
	int checkIsZb(@Param("importBatchId") Long importBatchId, @Param("comId") Long comId);

	/**
	 * <b> 校验导入的人员是否存在人事的组织架构里 </b>
	 * @author ZXF
	 * @create 2020/02/18 0018 14:55
	 * @version
	 * @注意事项 </b>
	 */
	int checkIdCardNoInPerBaseInfo(@Param("importBatchId") Long importBatchId, @Param("comId") Long comId);

	/**
	 * <b> 根据批次Id和企业Id查询该批次人员对应的保单信息(对应批量导入减员功能返回的有效结果集) </b>
	 * @author ZXF
	 * @create 2020/06/04 0004 17:19
	 * @version
	 * @注意事项 </b>
	 */
	List<Map<String,String>> findValidMinusInsByImportBatchId(@Param("importBatchId") Long importBatchId, @Param("comId") Long comId);

	/**
	 * <b> 根据批次id查询错误的条目 做导出 </b>
	 * @author ZXF
	 * @create 2020/01/16 0016 11:31
	 * @version
	 * @注意事项 </b>
	 */
	List<InsPerExcelBean> findErrTempBatchInsPerImport(@Param("importBatchId") Long importBatchId);

	/**
	 * <b> 根据批次Id和身份证列获取临时表人员并装到InsPreservationDetailVo </b>
	 * @author ZXF
	 * @create 2020/01/16 0016 19:03
	 * @version
	 * @注意事项 </b>
	 */
	List<InsPreservationDetailVo> getBlbVoByTempBatchInsPerImport(@Param("importBatchId") Long importBatchId);

	/**
	 * <b> 根据批次Id查询有效数据装BLBComInfoDTO </b>
	 * @author ZXF
	 * @create 2020/01/16 0016 20:22
	 * @version
	 * @注意事项 </b>
	 */
	List<BLBComInfoDTO> getTempBatchInsPerByImportBatchId(@Param("importBatchId") Long importBatchId);
}