package com.bcxin.platform.mapper.attend;

import java.util.List;

import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.domain.attend.AttendAddress;
import org.apache.ibatis.annotations.Param;
import com.bcxin.platform.domain.attend.AttendWifi;

/**
 * 考勤wifiMapper接口
 * 
 * @author lin
 * @date 2022-04-09
 */
public interface AttendWifiMapper{

    /**
     * 查询考勤wifi
     * 
     * @param id 考勤wifiID
     * @return 考勤wifi
     */
    AttendWifi findById(Long id);

    /**
     * 查询考勤wifi列表
     * 
     * @param attendWifi 考勤wifi
     * @return 考勤wifi集合
     */
    List<AttendWifi> selectList(AttendWifi attendWifi);

    /**
     * 删除考勤wifi
     * 
     * @param id 考勤wifiID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤wifi
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendWifi
     * @return
     */
    int save(AttendWifi attendWifi);

    /****
     * 选择修改
     * @param attendWifi
     * @return
     */
    int updateSelective(AttendWifi attendWifi);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendWifi> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendWifi> findByBatchId(@Param("list") List<AttendWifi> list);

    List<AttendWifi> findByAttendId(Long attendId);

    int deleteByAttendId(Attend attend);
}
