package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendDict;
import com.bcxin.platform.dto.attend.AttendDictDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 类别Mapper接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendDictMapper{

    /**
     * 查询类别
     * 
     * @param id 类别ID
     * @return 类别
     */
    AttendDict findById(Long id);

    /**
     * 查询类别列表
     * 
     * @param attendDict 类别
     * @return 类别集合
     */
    List<AttendDictDto> selectList(AttendDictDto attendDict);

    /**
     * 删除类别
     * 
     * @param id 类别ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除类别
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendDict
     * @return
     */
    int save(AttendDict attendDict);

    /****
     * 选择修改
     * @param attendDict
     * @return
     */
    int updateSelective(AttendDict attendDict);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendDict> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendDict> findByBatchId(@Param("list") List<AttendDict> list);

}
