package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendClockDetail;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤打卡记录Mapper接口
 * 
 * @author lin
 * @date 2021-08-27
 */
public interface AttendClockDetailMapper {

    /**
     * 查询考勤打卡记录
     * 
     * @param id 考勤打卡记录ID
     * @return 考勤打卡记录
     */
    AttendClockDetail findById(Long id);

    /**
     * 删除考勤打卡记录
     * 
     * @param id 考勤打卡记录ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤打卡记录
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendClockDetail
     * @return
     */
    int save(AttendClockDetail attendClockDetail);

    /****
     * 选择修改
     * @param attendClockDetail
     * @return
     */
    int updateSelective(AttendClockDetail attendClockDetail);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendClockDetail> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendClockDetail> findByBatchId(@Param("list") List<AttendClockDetail> list);

}
