package com.bcxin.platform.dto.order;

import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.domain.order.ComOrder;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
@DisMultiTenancy
public class ComOrderDto extends ComOrder {

    /** 订单详情列表字符串 */
    @ApiModelProperty(value = "订单详情列表字符串")
    private String orderDetailListStr;

    /** 产品范畴 */
    @ApiModelProperty(value = "产品范畴")
    private String productCategory;

    /** 短信验证码 */
    @ApiModelProperty(value = "短信验证码")
    private String activeCode;

    /** 订单详情列表 */
    @ApiModelProperty(value = "订单详情列表")
    private List<Map<String,Object>> orderDetailList;

    /** 优惠券ID */
    @ApiModelProperty(value = "优惠券ID")
    private Long productCouponId;
}
