package com.bcxin.platform.dto.message;

import com.bcxin.platform.util.BaseEntity;
import lombok.Data;

/**
 * <p>
 * 消息通知模块 消息对象DTO
 * </p>
 *
 * @author 罗鹏
 * @date 2018/4/8
 */
@Data
public class MessageDomainDTO extends BaseEntity {

	/**
	 * 收件人身份证
	 */
	private String idNumbers;
	/**
	 * 标题
	 */
	private String title;

	/**
	 * 内容
	 */
	private String content;

	/**
	 * 消息编码
	 */
	private String smsCode;

	/**
	 * 消息参数
	 */
	private String smsParam;

	/**
	 * 接收人id
	 */
	private Long perId;

	/**
	 * 公司id
	 */
	private Long comId;

	/**
	 * 平台id
	 */
	private Long platId;

	private String enclosureUrl;

	/**
	 * 任务id
	 */
	private Long comTaskId;

	private String examUrl;

	/**
	 * 审批
	 */
	private Long approveApplyId;

	private String approveType;

	/**
	 * 消息小分类
	 */
	private String messageType;

	/**
	 * 收件人集合，多个用,隔开
	 */
	private String ids;

	/* 什么方式发 */
	/* 1：sms ，2：email ， 3：app */
	/* 传值 1;2;3 */
	private String way;

	private String callback;

	private String extra;

	/**
	 * 公安区域ID
	 */
	private Long policeRegionId;

	/**
	 * 通用对象id
	 */
	private Long objectId;
}
