package com.bcxin.platform.dto.meeting;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class ResourceItemDTO {

    /**
     * 用户购买的云服务产品对应的云服务类型，例如：普通会议服务资源为"hws.service.type.cloudvc",
     */
    @ApiModelProperty(value = "用户购买的云服务产品对应的云服务类型")
    private String service_type;

    /**
     * 用户购买云服务产品的资源类型，例如：会议并发方数类型为"hws.resource.type.vc.concurrentport"。res_type是service_type中的一种资源，service_type由多种res_type组合提供。
     */
    @ApiModelProperty(value = "用户购买云服务产品的资源类型")
    private String res_type;

    /**
     * 用户购买云服务产品的资源规格，例如：会议25方VMR会议资源规格为"vc-vmr-25",
     */
    @ApiModelProperty(value = "用户购买云服务产品的资源规格")
    private String res_spec_code;

    /**
     * 资源容量/数量大小，例如购买的并发方数。
     */
    @ApiModelProperty(value = "资源容量/数量大小")
    private String res_size;

}
