package com.bcxin.platform.domain.grant;


import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 *
 * 银行网点工作日时间段人数上限配置表
 *
 *
 * @author llc
 * @date 2020-08-20
 */
@TableName("config_bank_outlets_work_day_time_period")
@DisMultiTenancy
@Data
public class ConfigBankOutletsWorkDayTimePeriod extends BaseParam {

    /**
     * 主键
     */
	private Integer id;

    /**
     * 银行网点工作日ID
     */
    private Integer bankOutletsWorkDayId;

    /** 开始时间 */
    @ApiModelProperty(value = "开始时间")
    private Date startTime;

    /** 结束时间 */
    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    /**
     * 人数上限
     */
    private Integer maxPerNum;

}
