package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 考勤wifi对象 tb_attend_wifi
 * 
 * @author lin
 * @date 2022-04-09
 */
@Data
public class AttendWifi extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /** 考勤wifi ID */
    @NotNull(message="考勤wifi ID不能为空", groups = {UpdateGroup.class})
    private Long id;

    /** 是否删除 1是0否 */
    @Excel(name = "是否删除 1是0否")
    private String isDelete;

    /** wifi名称 */
    @Excel(name = "wifi名称")
    @NotBlank(message="wifi名称不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String wifiName;

    /** wifi设备mac地址 */
    @Excel(name = "wifi设备mac地址")
    @NotBlank(message="mac地址不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String wifiMac;

    /** 考勤套ID */
    @NotNull(message="考勤套ID不能为空", groups = {AddGroup.class})
    private Long attendId;

}
