package com.bcxin.oaflow.service.impl;

import com.bcxin.oaflow.domain.PublicRelease;
import com.bcxin.oaflow.mapper.PublicReleaseMapper;
import com.bcxin.oaflow.service.PublicReleaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 公出Service业务层处理
 * 
 * @author lin
 * @date 2021-09-01
 */
@Service
public class PublicReleaseServiceImpl implements PublicReleaseService {

    @Autowired
    private PublicReleaseMapper publicReleaseMapper;


    /**
     * 查询公出
     * 
     * @param id 公出ID
     * @return 公出
     */
    @Override
    public PublicRelease findById(String id){
        return publicReleaseMapper.findById(id);
    }

    /**
     * 查询公出列表
     *
     * @param tlkPerIds
     * @param schedulDate
     * @return 公出
     */
    @Override
    public List<PublicRelease> selectList(List<String> tlkPerIds,String schedulDate){
        return publicReleaseMapper.selectList(tlkPerIds,schedulDate);
    }

}
