import Vue from "vue";
import VueRouter from "vue-router";

Vue.use(VueRouter);

const routes = [
  {
    path: "/",
    redirect: "/signIn",
  },
  {
    path: "/signIn",
    name: "signIn",
    component: () => import("@/views/SignIn/index.vue"),
  },
  {
    path: "/duty",
    name: "duty",
    // route level code-splitting
    // this generates a separate chunk (About.[hash].js) for this route
    // which is lazy-loaded when the route is visited.
    component: () => import("@/views/Duty/index.vue"),
  },
  {
    path: "*",
    redirect: "/signIn",
  },
];

const originalPush = VueRouter.prototype.push;
VueRouter.prototype.push = function push(location) {
  return originalPush.call(this, location).catch((err) => err);
};

const router = new VueRouter({
  mode: "hash",
  base: process.env.BASE_URL || "/",
  routes,
});

export default router;
