import { blobValidate } from "@/utils";
import axios from "axios";
import { Message, Loading } from "element-ui";
import { saveAs } from "file-saver";

const serviceAccess = axios.create({
  baseURL: process.env.VUE_APP_API_ROOT,
  timeout: 60000, // request timeout
  transformResponse: [
    (data) => {
      // 如果 data 不是对象，则直接返回原数据
      if (typeof data !== "object" || data === null) {
        return {
          data: JSON.parse(data),
        };
      }
      // 如果 data 已经是一个对象，则直接返回，否则假设它在一个 data 键下
      return data.data || data;
    },
  ],
});

serviceAccess.interceptors.request.use(
  async (config) => {
    const urlStr = window.location.href?.split("?")[1];
    const params = new URLSearchParams(urlStr);
    const accessToken = params.get("Accesstoken");
    const env = process.env.NODE_ENV;
    // console.log("env", env);
    if (env === "development" && !accessToken) {
      // 签到统计：Accesstoken：
      config.headers.accessToken =
        "eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTc0NjY4MTU0MCwidXNlcm5hbWUiOiJ4SWt1Zlg1NF9BSUVpRTJSRyJ9.kIY8DyXsTiZSxmoPdrUuaAKQZCWTcKnByyVzduuTA6M";
      //   考勤统计：Accesstoken：
      // config.headers.accessToken =
      //   "eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTc0NjU5NTI5MCwidXNlcm5hbWUiOiIyblVpZTQxeF9kSUpqS3BjaiJ9.SsSWTGOurd0fK7xVVRyZEfac203I7MHEduq7MEKJJA4";
    }
    if (accessToken) {
      config.headers.accessToken = accessToken;
    }
    return config;
  },
  (err) => {
    return Promise.reject(err);
  }
);

serviceAccess.interceptors.response.use((response) => {
  const { status, data } = response;
  if (status === 200) {
    return data;
  }
});

const serviceDispatch = axios.create({
  baseURL: process.env.VUE_APP_API_ROOT,
  timeout: 60000, // request timeout
});

serviceDispatch.interceptors.request.use(
  async (config) => {
    // config.headers["skip-ip-validation"] = 1;
    const dispatchToken = localStorage.getItem("dispatchToken");
    if (dispatchToken) {
      config.headers.dispatchToken = dispatchToken;
    }
    return config;
  },
  (error) => {
    return Promise.reject(error);
  }
);

serviceDispatch.interceptors.response.use((response) => {
  const { status, data } = response;
  if (status === 200) {
    const { url } = response.config;
    if (url && url.indexOf("json") > -1) {
      // mock api
      return data;
    } else {
      return data.data;
    }
  }
});

export { serviceAccess, serviceDispatch };

export async function requestAccess(config) {
  // axios实例的 request 接受的第一个泛型参数，就是返回数据data的类型
  return serviceAccess.request(config).then((res) => res.data); // 返回axios的里data数据
}

// 通用下载方法
let downloadLoadingInstance = null;
export function download(url, params, filename, config = {}) {
  downloadLoadingInstance = Loading.service({
    text: "正在下载数据，请稍候",
    background: "rgba(0, 0, 0, 0.7)",
  });
  return serviceAccess
    .post(url, params, {
      // transformRequest: [
      //   (params) => {
      //     return tansParams(params)
      //   },
      // ],
      headers: { "Content-Type": "application/json" },
      responseType: "blob",
      ...config,
    })
    .then(async (data) => {
      const isBlob = blobValidate(data);
      if (isBlob) {
        const blob = new Blob([data]);
        saveAs(blob, filename);
      } else {
        const resText = await data.text();
        const rspObj = JSON.parse(resText);
        Message.error(rspObj.msg);
      }
      downloadLoadingInstance?.close();
    })
    .catch((r) => {
      console.error(r);
      Message.error("下载文件出现错误，请联系管理员！");
      downloadLoadingInstance?.close();
    });
}
