import XEUtils from './xe-utils'

// core
export * from './xe-utils'

// object
export * from './object/assign'
export * from './object/extend'
export * from './object/objectEach'
export * from './object/lastObjectEach'
export * from './object/objectMap'
export * from './object/merge'

// array
export * from './array/map'
export * from './array/some'
export * from './array/every'
export * from './array/includeArrays'
export * from './array/arrayEach'
export * from './array/lastArrayEach'
export * from './array/uniq'
export * from './array/union'
export * from './array/toArray'
export * from './array/sortBy'
export * from './array/orderBy'
export * from './array/shuffle'
export * from './array/sample'
export * from './array/slice'
export * from './array/filter'
export * from './array/findKey'
export * from './array/includes'
export * from './array/find'
export * from './array/findLast'
export * from './array/reduce'
export * from './array/copyWithin'
export * from './array/chunk'
export * from './array/zip'
export * from './array/unzip'
export * from './array/zipObject'
export * from './array/pluck'
export * from './array/invoke'
export * from './array/invokeMap'
export * from './array/toArrayTree'
export * from './array/toTreeArray'
export * from './array/findTree'
export * from './array/eachTree'
export * from './array/mapTree'
export * from './array/filterTree'
export * from './array/searchTree'
export * from './array/arrayIndexOf'
export * from './array/arrayLastIndexOf'

// base
export * from './base/hasOwnProp'
export * from './base/isArray'
export * from './base/isNull'
export * from './base/isNaN'
export * from './base/isUndefined'
export * from './base/isFunction'
export * from './base/isObject'
export * from './base/isString'
export * from './base/isPlainObject'
export * from './base/isLeapYear'
export * from './base/isDate'
export * from './base/eqNull'
export * from './base/each'
export * from './base/forOf'
export * from './base/lastForOf'
export * from './base/indexOf'
export * from './base/lastIndexOf'
export * from './base/keys'
export * from './base/values'
export * from './base/clone'
export * from './base/getSize'
export * from './base/lastEach'
export * from './base/remove'
export * from './base/clear'
export * from './base/isFinite'
export * from './base/isFloat'
export * from './base/isInteger'
export * from './base/isBoolean'
export * from './base/isNumber'
export * from './base/isRegExp'
export * from './base/isError'
export * from './base/isTypeError'
export * from './base/isEmpty'
export * from './base/isSymbol'
export * from './base/isArguments'
export * from './base/isElement'
export * from './base/isDocument'
export * from './base/isWindow'
export * from './base/isFormData'
export * from './base/isMap'
export * from './base/isWeakMap'
export * from './base/isSet'
export * from './base/isWeakSet'
export * from './base/isMatch'
export * from './base/isEqual'
export * from './base/isEqualWith'
export * from './base/getType'
export * from './base/uniqueId'
export * from './base/findIndexOf'
export * from './base/findLastIndexOf'
export * from './base/toStringJSON'
export * from './base/toJSONString'
export * from './base/entries'
export * from './base/pick'
export * from './base/omit'
export * from './base/first'
export * from './base/last'
export * from './base/has'
export * from './base/get'
export * from './base/set'
export * from './base/groupBy'
export * from './base/countBy'
export * from './base/range'
export * from './base/destructuring'

// number
export * from './number/random'
export * from './number/max'
export * from './number/min'
export * from './number/commafy'
export * from './number/round'
export * from './number/ceil'
export * from './number/floor'
export * from './number/toFixed'
export * from './number/toFixedString'
export * from './number/toFixedNumber'
export * from './number/toInteger'
export * from './number/toNumber'
export * from './number/toNumberString'
export * from './number/add'
export * from './number/subtract'
export * from './number/multiply'
export * from './number/divide'
export * from './number/sum'
export * from './number/mean'

// date
export * from './date/getWhatYear'
export * from './date/getWhatMonth'
export * from './date/getWhatDay'
export * from './date/toStringDate'
export * from './date/toDateString'
export * from './date/now'
export * from './date/timestamp'
export * from './date/isValidDate'
export * from './date/isDateSame'
export * from './date/getWhatWeek'
export * from './date/getYearDay'
export * from './date/getYearWeek'
export * from './date/getMonthWeek'
export * from './date/getDayOfYear'
export * from './date/getDayOfMonth'
export * from './date/getDateDiff'

// string
export * from './string/padEnd'
export * from './string/padStart'
export * from './string/repeat'
export * from './string/trim'
export * from './string/trimRight'
export * from './string/trimLeft'
export * from './string/escape'
export * from './string/unescape'
export * from './string/camelCase'
export * from './string/kebabCase'
export * from './string/startsWith'
export * from './string/endsWith'
export * from './string/template'
export * from './string/toFormatString'
export * from './string/toString'

// function
export * from './function//noop'
export * from './function/property'
export * from './function/bind'
export * from './function/once'
export * from './function/after'
export * from './function/before'
export * from './function/throttle'
export * from './function/debounce'
export * from './function/delay'

// url
export * from './url/unserialize'
export * from './url/serialize'
export * from './url/parseUrl'

// web
export * from './web/getBaseURL'
export * from './web/locat'
export * from './web/cookie'
export * from './web/browse'

export default XEUtils
