import GlobalConfig from '../../conf'
import VXETable from '../../v-x-e-table'
import { UtilTools } from '../../tools'

export default {
  name: 'PlxImportPanel',
  props: {
    defaultOptions: Object,
    storeData: Object
  },
  computed: {
    vSize () {
      return this.size || this.$parent.size || this.$parent.vSize
    },
    selectName () {
      return `${this.storeData.filename}.${this.storeData.type}`
    },
    hasFile () {
      return this.storeData.file && this.storeData.type
    },
    parseTypeLabel () {
      const { storeData } = this
      if (storeData.type) {
        return GlobalConfig.i18n(`plx.types.${storeData.type}`)
      }
      return `*.${(this.defaultOptions.types || VXETable.importTypes).join(', *.')}`
    }
  },
  render (h) {
    const { hasFile, parseTypeLabel, defaultOptions, storeData, selectName } = this
    return h('plx-modal', {
      res: 'modal',
      model: {
        value: storeData.visible,
        callback (value) {
          storeData.visible = value
        }
      },
      props: {
        title: GlobalConfig.i18n('plx.toolbar.impTitle'),
        width: 440,
        mask: true,
        lockView: true,
        showFooter: false,
        escClosable: true,
        maskClosable: true
      }
    }, [
      h('div', {
        class: 'plx-export--panel'
      }, [
        h('table', {
          attrs: {
            cellspacing: 0,
            cellpadding: 0,
            border: 0
          }
        }, [
          h('tr', [
            h('td', GlobalConfig.i18n('plx.toolbar.impFile')),
            h('td', [
              hasFile ? h('div', {
                class: 'plx-import-selected--file',
                attrs: {
                  title: selectName
                }
              }, [
                h('span', selectName),
                h('i', {
                  class: GlobalConfig.icon.importRemove,
                  on: {
                    click: this.clearFileEvent
                  }
                })
              ]) : h('span', {
                class: 'plx-import-select--file',
                on: {
                  click: this.selectFileEvent
                }
              }, GlobalConfig.i18n('plx.toolbar.impSelect'))
            ])
          ]),
          h('tr', [
            h('td', GlobalConfig.i18n('plx.toolbar.impType')),
            h('td', parseTypeLabel)
          ]),
          h('tr', [
            h('td', GlobalConfig.i18n('plx.toolbar.impOpts')),
            h('td', [
              h('plx-radio', {
                props: {
                  name: 'mode',
                  label: 'covering',
                  title: GlobalConfig.i18n('plx.toolbar.impCoveringTitle')
                },
                model: {
                  value: defaultOptions.mode,
                  callback (value) {
                    defaultOptions.mode = value
                  }
                }
              }, GlobalConfig.i18n('plx.toolbar.impModeCovering')),
              h('plx-radio', {
                props: {
                  name: 'mode',
                  label: 'append',
                  title: GlobalConfig.i18n('plx.toolbar.impAppendTitle')
                },
                model: {
                  value: defaultOptions.mode,
                  callback (value) {
                    defaultOptions.mode = value
                  }
                }
              }, GlobalConfig.i18n('plx.toolbar.impModeAppend'))
            ])
          ])
        ]),
        h('div', {
          class: 'plx-export--panel-btns'
        }, [
          h('plx-button', {
            props: {
              type: 'primary',
              disabled: !hasFile
            },
            on: {
              click: this.importEvent
            }
          }, GlobalConfig.i18n('plx.toolbar.impConfirm'))
        ])
      ])
    ])
  },
  methods: {
    clearFileEvent () {
      Object.assign(this.storeData, {
        filename: '',
        sheetName: '',
        type: ''
      })
    },
    selectFileEvent () {
      const { $grid, $table } = this.$parent
      const comp = $grid || $table
      if (comp) {
        comp.readFile(this.defaultOptions).then(evnt => {
          const file = evnt.target.files[0]
          Object.assign(this.storeData, UtilTools.parseFile(file), { file })
        }).catch(e => e)
      }
    },
    importEvent () {
      const { storeData, defaultOptions } = this
      const opts = Object.assign({}, defaultOptions)
      storeData.visible = false
      this.$emit('import', opts)
    }
  }
}
