"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.default=void 0;var _xeUtils=_interopRequireDefault(require("xe-utils/methods/xe-utils")),_conf=_interopRequireDefault(require("../../conf")),_tools=require("../../tools");function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _defineProperty(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}var _default2={name:"PlxPager",props:{size:String,layouts:{type:Array,default:function(){return _conf.default.pager.layouts||["PrevJump","PrevPage","Jump","PageCount","NextPage","NextJump","Sizes","Total"]}},currentPage:{type:Number,default:1},loading:Boolean,pageSize:{type:Number,default:function(){return _conf.default.pager.pageSize||10}},total:{type:Number,default:0},pagerCount:{type:Number,default:function(){return _conf.default.pager.pagerCount||7}},pageSizes:{type:Array,default:function(){return _conf.default.pager.pageSizes||[10,15,20,50,100]}},align:{type:String,default:function(){return _conf.default.pager.align}},border:{type:Boolean,default:function(){return _conf.default.pager.border}},background:{type:Boolean,default:function(){return _conf.default.pager.background}},perfect:{type:Boolean,default:function(){return _conf.default.pager.perfect}},iconPrevPage:String,iconJumpPrev:String,iconJumpNext:String,iconNextPage:String,iconJumpMore:String},inject:{$grid:{default:null}},data:function(){return{showSizes:!1,panelStyle:null,panelIndex:0}},computed:{vSize:function(){return this.size||this.$parent.size||this.$parent.vSize},isSizes:function(){return this.layouts.some(function(e){return"Sizes"===e})},pageCount:function(){return this.getPageCount(this.total,this.pageSize)},numList:function(){for(var e=this.pageCount>this.pagerCount?this.pagerCount-2:this.pagerCount,t=[],n=0;n<e;n++)t.push(n);return t},offsetNumber:function(){return Math.floor((this.pagerCount-2)/2)}},created:function(){this.panelIndex=_tools.UtilTools.nextZIndex(),_tools.GlobalEvent.on(this,"mousedown",this.handleGlobalMousedownEvent)},destroyed:function(){_tools.GlobalEvent.off(this,"mousedown")},render:function(t){var e,n=this,a=this.vSize,i=this.align;return t("div",{class:["plx-pager",(_defineProperty(e={},"size--".concat(a),a),_defineProperty(e,"align--".concat(i),i),_defineProperty(e,"p--border",this.border),_defineProperty(e,"p--background",this.background),_defineProperty(e,"p--perfect",this.perfect),_defineProperty(e,"is--loading",this.loading),e)]},[t("div",{class:"plx-pager--wrapper"},this.layouts.map(function(e){return n["render".concat(e)](t)}))])},methods:{renderPrevPage:function(e){return e("span",{class:["plx-pager--prev-btn",{"is--disabled":this.currentPage<=1}],attrs:{title:_conf.default.i18n("plx.pager.prevPage")},on:{click:this.prevPage}},[e("i",{class:["plx-pager--btn-icon",this.iconPrevPage||_conf.default.icon.prevPage]})])},renderPrevJump:function(e,t){return e(t||"span",{class:["plx-pager--jump-prev",{"is--fixed":!t,"is--disabled":this.currentPage<=1}],attrs:{title:_conf.default.i18n("plx.pager.prevJump")},on:{click:this.prevJump}},[t?e("i",{class:["plx-pager--jump-more",this.iconJumpMore||_conf.default.icon.jumpMore]}):null,e("i",{class:["plx-pager--jump-icon",this.iconJumpPrev||_conf.default.icon.jumpPrev]})])},renderNumber:function(e){return e("ul",{class:"plx-pager--btn-wrapper"},this.renderPageBtn(e))},renderJumpNumber:function(e){return e("ul",{class:"plx-pager--btn-wrapper"},this.renderPageBtn(e,!0))},renderNextJump:function(e,t){return e(t||"span",{class:["plx-pager--jump-next",{"is--fixed":!t,"is--disabled":this.currentPage>=this.pageCount}],attrs:{title:_conf.default.i18n("plx.pager.nextJump")},on:{click:this.nextJump}},[t?e("i",{class:["plx-pager--jump-more",this.iconJumpMore||_conf.default.icon.jumpMore]}):null,e("i",{class:["plx-pager--jump-icon",this.iconJumpNext||_conf.default.icon.jumpNext]})])},renderNextPage:function(e){return e("span",{class:["plx-pager--next-btn",{"is--disabled":this.currentPage>=this.pageCount}],attrs:{title:_conf.default.i18n("plx.pager.nextPage")},on:{click:this.nextPage}},[e("i",{class:["plx-pager--btn-icon",this.iconNextPage||_conf.default.icon.nextPage]})])},renderSizes:function(t){var n=this;return t("span",{class:["plx-pager--sizes",{"is--active":this.showSizes}],ref:"sizeBtn"},[t("span",{class:"size--content",on:{click:this.toggleSizePanel}},[t("span","".concat(this.pageSize).concat(_conf.default.i18n("plx.pager.pagesize"))),t("i",{class:"plx-pager--sizes-arrow ".concat(_conf.default.icon.caretBottom)})]),t("div",{class:"plx-pager-size--select-wrapper",style:this.panelStyle,ref:"sizePanel"},[t("ul",{class:"plx-pager-size--select"},this.pageSizes.map(function(e){return t("li",{class:["size--option",{"is--active":e===n.pageSize}],on:{click:function(){return n.changePageSize(e)}}},"".concat(e).concat(_conf.default.i18n("plx.pager.pagesize")))}))])])},renderFullJump:function(e){return this.renderJump(e,!0)},renderJump:function(e,t){return e("span",{class:"plx-pager--jump"},[t?e("span",{class:"plx-pager--goto-text"},_conf.default.i18n("plx.pager.goto")):null,e("input",{class:"plx-pager--goto",domProps:{value:this.currentPage},attrs:{type:"text",autocomplete:"off"},on:{keydown:this.jumpKeydownEvent}}),t?e("span",{class:"plx-pager--classifier-text"},_conf.default.i18n("plx.pager.pageClassifier")):null])},renderPageCount:function(e){return e("span",{class:"plx-pager--count"},[e("span",{class:"plx-pager--separator"},"/"),e("span",this.pageCount)])},renderTotal:function(e){return e("span",{class:"plx-pager--total"},_xeUtils.default.template(_conf.default.i18n("plx.pager.total"),{total:this.total}))},renderPageBtn:function(a,e){var i=this,t=this.numList,r=this.currentPage,o=this.pageCount,n=this.pagerCount,s=this.offsetNumber,u=[],l=n<o,p=l&&s+1<r,c=l&&r<o-s,g=1;return l&&(g=o-s<=r?Math.max(o-t.length+1,1):Math.max(r-s,1)),e&&p&&u.push(a("li",{class:"plx-pager--num-btn",on:{click:function(){return i.jumpPage(1)}}},1),this.renderPrevJump(a,"li")),t.forEach(function(e,t){var n=g+t;n<=o&&u.push(a("li",{class:["plx-pager--num-btn",{"is--active":r===n}],on:{click:function(){return i.jumpPage(n)}},key:n},n))}),e&&c&&u.push(this.renderNextJump(a,"li"),a("li",{class:"plx-pager--num-btn",on:{click:function(){return i.jumpPage(o)}}},o)),u},getPageCount:function(e,t){return Math.max(Math.ceil(e/t),1)},handleGlobalMousedownEvent:function(e){var t=this.$refs;!this.showSizes||_tools.DomTools.getEventTargetNode(e,t.sizeBtn).flag||_tools.DomTools.getEventTargetNode(e,t.sizePanel).flag||this.hideSizePanel()},prevPage:function(){var e=this.currentPage;1<e&&this.jumpPage(Math.max(e-1,1))},nextPage:function(){var e=this.currentPage,t=this.pageCount;e<t&&this.jumpPage(Math.min(e+1,t))},prevJump:function(){this.jumpPage(Math.max(this.currentPage-this.numList.length,1))},nextJump:function(){this.jumpPage(Math.min(this.currentPage+this.numList.length,this.pageCount))},jumpPage:function(e){var t="current-change";e!==this.currentPage&&(this.$emit("update:currentPage",e),_tools.UtilTools.emitEvent(this,t,[e]),this.emitPageChange(t,this.pageSize,e))},changePageSize:function(e){var t="size-change";e!==this.pageSize&&(this.$emit("update:pageSize",e),_tools.UtilTools.emitEvent(this,t,[e]),this.emitPageChange(t,e,Math.min(this.currentPage,this.getPageCount(this.total,e)))),this.hideSizePanel()},jumpKeydownEvent:function(e){if(13===e.keyCode){var t=_xeUtils.default.toNumber(e.target.value),n=t<=0?1:t>=this.pageCount?this.pageCount:t;e.target.value=n,this.jumpPage(n)}else 38===e.keyCode?(e.preventDefault(),this.nextPage()):40===e.keyCode&&(e.preventDefault(),this.prevPage())},emitPageChange:function(e,t,n){_tools.UtilTools.emitEvent(this,"page-change",[{type:e,pageSize:t,currentPage:n}])},toggleSizePanel:function(){this[this.showSizes?"hideSizePanel":"showSizePanel"]()},updateZindex:function(){this.panelIndex<_tools.UtilTools.getLastZIndex()&&(this.panelIndex=_tools.UtilTools.nextZIndex())},showSizePanel:function(){var a=this;this.showSizes=!0,this.updateZindex(),this.$nextTick(function(){var e=a.$refs,t=e.sizeBtn,n=e.sizePanel;a.panelStyle={zIndex:a.panelIndex,bottom:"".concat(t.clientHeight+6,"px"),left:"-".concat(n.clientWidth/2-t.clientWidth/2,"px")}})},hideSizePanel:function(){this.showSizes=!1}}};exports.default=_default2;