Object.defineProperty(exports, "__esModule", { value: true });
exports.collectCssVars = exports.collectStyleCssClasses = void 0;
const reactivity_1 = require("@vue/reactivity");
const script_1 = require("../generators/script");
const templateGen = require("../generators/template");
const scriptRanges_1 = require("../parsers/scriptRanges");
const scriptSetupRanges_1 = require("../parsers/scriptSetupRanges");
const parseCssClassNames_1 = require("../utils/parseCssClassNames");
const parseCssVars_1 = require("../utils/parseCssVars");
const plugin = ({ modules, vueCompilerOptions, compilerOptions }) => {
    const ts = modules.typescript;
    const gen = new WeakMap();
    return {
        getEmbeddedFileNames(fileName, sfc) {
            const fileNames = [];
            const _gen = useGen(fileName, sfc);
            if ((_gen === null || _gen === void 0 ? void 0 : _gen.lang.value) && ['js', 'ts', 'jsx', 'tsx'].includes(_gen.lang.value)) {
                fileNames.push(fileName + '.' + _gen.lang.value);
            }
            if (sfc.template) {
                fileNames.push(fileName + '.__VLS_template_format.tsx');
                fileNames.push(fileName + '.__VLS_template_style.css');
            }
            return fileNames;
        },
        resolveEmbeddedFile(fileName, sfc, embeddedFile) {
            var _a, _b;
            const suffix = embeddedFile.fileName.replace(fileName, '');
            const _gen = useGen(fileName, sfc);
            if (suffix === '.' + (_gen === null || _gen === void 0 ? void 0 : _gen.lang.value)) {
                embeddedFile.isTsHostFile = true;
                embeddedFile.capabilities = {
                    diagnostics: true,
                    foldingRanges: false,
                    formatting: false,
                    documentSymbol: false,
                    codeActions: true,
                    inlayHints: true,
                };
                const tsx = _gen === null || _gen === void 0 ? void 0 : _gen.tsxGen.value;
                if (tsx) {
                    embeddedFile.codeGen.addText(tsx.codeGen.getText());
                    embeddedFile.codeGen.mappings = [...tsx.codeGen.mappings];
                    embeddedFile.teleportMappings = [...tsx.teleports];
                }
            }
            else if (suffix.match(/^\.__VLS_template_format\.tsx$/)) {
                embeddedFile.parentFileName = fileName + '.template.' + ((_a = sfc.template) === null || _a === void 0 ? void 0 : _a.lang);
                embeddedFile.capabilities = {
                    diagnostics: false,
                    foldingRanges: false,
                    formatting: true,
                    documentSymbol: true,
                    codeActions: false,
                    inlayHints: false,
                };
                embeddedFile.isTsHostFile = false;
                if (_gen === null || _gen === void 0 ? void 0 : _gen.htmlGen.value) {
                    embeddedFile.codeGen.addText(_gen.htmlGen.value.formatCodeGen.getText());
                    embeddedFile.codeGen.mappings = [..._gen.htmlGen.value.formatCodeGen.mappings];
                }
            }
            else if (suffix.match(/^\.__VLS_template_style\.css$/)) {
                embeddedFile.parentFileName = fileName + '.template.' + ((_b = sfc.template) === null || _b === void 0 ? void 0 : _b.lang);
                if (_gen === null || _gen === void 0 ? void 0 : _gen.htmlGen.value) {
                    embeddedFile.codeGen.addText(_gen.htmlGen.value.cssCodeGen.getText());
                    embeddedFile.codeGen.mappings = [..._gen.htmlGen.value.cssCodeGen.mappings];
                }
            }
        },
    };
    function useGen(fileName, sfc) {
        if (!gen.has(sfc)) {
            gen.set(sfc, createGen(fileName, sfc));
        }
        return gen.get(sfc);
    }
    function createGen(fileName, sfc) {
        const lang = (0, reactivity_1.computed)(() => {
            let lang = !sfc.script && !sfc.scriptSetup ? 'ts'
                : sfc.scriptSetup && sfc.scriptSetup.lang !== 'js' ? sfc.scriptSetup.lang
                    : sfc.script && sfc.script.lang !== 'js' ? sfc.script.lang
                        : 'js';
            const disableTemplateScript = vueCompilerOptions.experimentalDisableTemplateSupport || compilerOptions.jsx !== ts.JsxEmit.Preserve;
            if (!disableTemplateScript) {
                if (lang === 'js') {
                    lang = 'jsx';
                }
                else if (lang === 'ts') {
                    lang = 'tsx';
                }
            }
            return lang;
        });
        const cssVars = (0, reactivity_1.computed)(() => collectCssVars(sfc));
        const scriptRanges = (0, reactivity_1.computed)(() => sfc.scriptAst
            ? (0, scriptRanges_1.parseScriptRanges)(ts, sfc.scriptAst, !!sfc.scriptSetup, false, false)
            : undefined);
        const scriptSetupRanges = (0, reactivity_1.computed)(() => sfc.scriptSetupAst
            ? (0, scriptSetupRanges_1.parseScriptSetupRanges)(ts, sfc.scriptSetupAst)
            : undefined);
        const cssModuleClasses = (0, reactivity_1.computed)(() => collectStyleCssClasses(sfc, style => !!style.module));
        const cssScopedClasses = (0, reactivity_1.computed)(() => collectStyleCssClasses(sfc, style => {
            const setting = vueCompilerOptions.experimentalResolveStyleCssClasses;
            return (setting === 'scoped' && style.scoped) || setting === 'always';
        }));
        const htmlGen = (0, reactivity_1.computed)(() => {
            var _a, _b, _c, _d;
            if (!sfc.templateAst)
                return;
            return templateGen.generate(ts, vueCompilerOptions, (_b = (_a = sfc.template) === null || _a === void 0 ? void 0 : _a.content) !== null && _b !== void 0 ? _b : '', (_d = (_c = sfc.template) === null || _c === void 0 ? void 0 : _c.lang) !== null && _d !== void 0 ? _d : 'html', sfc.templateAst, !!sfc.scriptSetup, Object.values(cssScopedClasses.value).map(style => style.classNames).flat());
        });
        const tsxGen = (0, reactivity_1.computed)(() => (0, script_1.generate)(ts, fileName, sfc, lang.value, scriptRanges.value, scriptSetupRanges.value, cssVars.value, cssModuleClasses.value, cssScopedClasses.value, htmlGen.value, compilerOptions, vueCompilerOptions));
        return {
            lang,
            htmlGen,
            tsxGen,
        };
    }
};
exports.default = plugin;
function collectStyleCssClasses(sfc, condition) {
    const result = [];
    for (let i = 0; i < sfc.styles.length; i++) {
        const style = sfc.styles[i];
        if (condition(style)) {
            const classNameRanges = [...(0, parseCssClassNames_1.parseCssClassNames)(style.content)];
            result.push({
                style: style,
                index: i,
                classNameRanges: classNameRanges,
                classNames: classNameRanges.map(range => style.content.substring(range.start + 1, range.end)),
            });
        }
    }
    return result;
}
exports.collectStyleCssClasses = collectStyleCssClasses;
function collectCssVars(sfc) {
    const result = [];
    for (let i = 0; i < sfc.styles.length; i++) {
        const style = sfc.styles[i];
        result.push({
            style: style,
            styleIndex: i,
            ranges: [...(0, parseCssVars_1.parseCssVars)(style.content)],
        });
    }
    return result;
}
exports.collectCssVars = collectCssVars;
//# sourceMappingURL=vue-tsx.js.map