const CompilerDom = require("@vue/compiler-dom");
const CompilerVue2 = require("../utils/vue2TemplateCompiler");
const plugin = ({ vueCompilerOptions }) => {
    return {
        compileSFCTemplate(lang, template, options) {
            if (lang === 'pug') {
                let pug;
                try {
                    pug = require('@volar/pug-language-service');
                }
                catch (_a) { }
                const pugDoc = pug === null || pug === void 0 ? void 0 : pug.baseParse(template);
                if (pugDoc) {
                    const compiler = vueCompilerOptions.target < 3 ? CompilerVue2 : CompilerDom;
                    const completed = compiler.compile(pugDoc.htmlCode, Object.assign(Object.assign(Object.assign({}, options), vueCompilerOptions.experimentalTemplateCompilerOptions), { onWarn(warning) {
                            var _a;
                            (_a = options === null || options === void 0 ? void 0 : options.onWarn) === null || _a === void 0 ? void 0 : _a.call(options, createProxyObject(warning));
                        },
                        onError(error) {
                            var _a;
                            (_a = options === null || options === void 0 ? void 0 : options.onError) === null || _a === void 0 ? void 0 : _a.call(options, createProxyObject(error));
                        } }));
                    return createProxyObject(completed);
                    function createProxyObject(target) {
                        return new Proxy(target, {
                            get(target, prop) {
                                var _a, _b;
                                if (prop === 'offset') {
                                    const htmlOffset = target.offset;
                                    const pugOffset = (_b = (_a = pugDoc.sourceMap.getSourceRange(htmlOffset, htmlOffset, data => !(data === null || data === void 0 ? void 0 : data.isEmptyTagCompletion))) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.start;
                                    return pugOffset !== null && pugOffset !== void 0 ? pugOffset : -1;
                                }
                                const value = target[prop];
                                if (typeof value === 'object') {
                                    return createProxyObject(target[prop]);
                                }
                                return value;
                            }
                        });
                    }
                }
            }
        },
    };
};
module.exports = plugin;
//# sourceMappingURL=vue-template-pug.js.map