Object.defineProperty(exports, "__esModule", { value: true });
exports.generate = void 0;
const code_gen_1 = require("@volar/code-gen");
const SourceMaps = require("@volar/source-map");
const shared_1 = require("@vue/shared");
const path_1 = require("path");
const shared_2 = require("../utils/shared");
const string_1 = require("../utils/string");
const transform_1 = require("../utils/transform");
/**
 * TODO: rewrite this
 */
function generate(ts, fileName, sfc, lang, scriptRanges, scriptSetupRanges, cssVars, cssModuleClasses, cssScopedClasses, htmlGen, compilerOptions, vueCompilerOptions, codeGen = new code_gen_1.CodeGen(), teleports = []) {
    var _a;
    const downgradePropsAndEmitsToSetupReturnOnScriptSetup = vueCompilerOptions.experimentalDowngradePropsAndEmitsToSetupReturnOnScriptSetup === 'onlyJs'
        ? lang === 'js' || lang === 'jsx'
        : !!vueCompilerOptions.experimentalDowngradePropsAndEmitsToSetupReturnOnScriptSetup;
    const vueVersion = (_a = vueCompilerOptions.target) !== null && _a !== void 0 ? _a : 3;
    const vueLibName = (0, shared_2.getVueLibraryName)(vueVersion);
    const usedTypes = {
        DefinePropsToOptions: false,
        mergePropDefaults: false,
        ConstructorOverloads: false,
    };
    let exportdefaultStart;
    let exportdefaultEnd;
    writeScriptSrc();
    writeScriptSetupImportsSegment();
    writeScriptContentBeforeExportDefault();
    writeScriptSetupAndTemplate();
    writeScriptSetupTypes();
    writeScriptContentAfterExportDefault();
    writeTemplateIfNoScriptSetup();
    if (!sfc.script && !sfc.scriptSetup) {
        codeGen.addCode('export default {} as any', {
            start: 0,
            end: 0,
        }, SourceMaps.Mode.Expand, {
            vueTag: undefined,
            capabilities: {},
        });
    }
    if (sfc.scriptSetup) {
        // for code action edits
        codeGen.addCode('', {
            start: sfc.scriptSetup.content.length,
            end: sfc.scriptSetup.content.length,
        }, SourceMaps.Mode.Offset, {
            vueTag: 'scriptSetup',
            capabilities: {},
        });
    }
    // fix https://github.com/johnsoncodehk/volar/issues/1048
    // fix https://github.com/johnsoncodehk/volar/issues/435
    codeGen.addMapping2({
        data: {
            vueTag: undefined,
            capabilities: {},
        },
        mode: SourceMaps.Mode.Expand,
        mappedRange: {
            start: 0,
            end: codeGen.getText().length,
        },
        sourceRange: {
            start: 0,
            end: 0,
        },
    });
    // fix https://github.com/johnsoncodehk/volar/issues/1127
    if (sfc.scriptSetup && exportdefaultStart !== undefined && exportdefaultEnd !== undefined) {
        codeGen.addMapping2({
            data: {
                vueTag: 'scriptSetup',
                capabilities: {
                    diagnostic: true,
                },
            },
            mode: SourceMaps.Mode.Totally,
            mappedRange: {
                start: exportdefaultStart,
                end: exportdefaultEnd,
            },
            sourceRange: {
                start: 0,
                end: sfc.scriptSetup.content.length,
            },
        });
    }
    return {
        codeGen,
        teleports,
    };
    function writeScriptSetupTypes() {
        if (usedTypes.DefinePropsToOptions) {
            if (compilerOptions.exactOptionalPropertyTypes) {
                codeGen.addText(`type __VLS_TypePropsToRuntimeProps<T> = { [K in keyof T]-?: {} extends Pick<T, K> ? { type: import('${vueLibName}').PropType<T[K]> } : { type: import('${vueLibName}').PropType<T[K]>, required: true } };\n`);
            }
            else {
                codeGen.addText(`type __VLS_NonUndefinedable<T> = T extends undefined ? never : T;\n`);
                codeGen.addText(`type __VLS_TypePropsToRuntimeProps<T> = { [K in keyof T]-?: {} extends Pick<T, K> ? { type: import('${vueLibName}').PropType<__VLS_NonUndefinedable<T[K]>> } : { type: import('${vueLibName}').PropType<T[K]>, required: true } };\n`);
            }
        }
        if (usedTypes.mergePropDefaults) {
            codeGen.addText(`type __VLS_WithDefaults<P, D> = {
					// use 'keyof Pick<P, keyof P>' instead of 'keyof P' to keep props jsdoc
					[K in keyof Pick<P, keyof P>]: K extends keyof D ? P[K] & {
						default: D[K]
					} : P[K]
				};\n`);
        }
        if (usedTypes.ConstructorOverloads) {
            // fix https://github.com/johnsoncodehk/volar/issues/926
            codeGen.addText('type __VLS_UnionToIntersection<U> = (U extends unknown ? (arg: U) => unknown : never) extends ((arg: infer P) => unknown) ? P : never;\n');
            if (scriptSetupRanges && scriptSetupRanges.emitsTypeNums !== -1) {
                codeGen.addText(genConstructorOverloads('__VLS_ConstructorOverloads', scriptSetupRanges.emitsTypeNums));
            }
            else {
                codeGen.addText(genConstructorOverloads('__VLS_ConstructorOverloads'));
            }
        }
    }
    function writeScriptSrc() {
        var _a;
        if (!((_a = sfc.script) === null || _a === void 0 ? void 0 : _a.src))
            return;
        let src = sfc.script.src;
        if (src.endsWith('.d.ts'))
            src = src.substring(0, src.length - '.d.ts'.length);
        else if (src.endsWith('.ts'))
            src = src.substring(0, src.length - '.ts'.length);
        else if (src.endsWith('.tsx'))
            src = src.substring(0, src.length - '.tsx'.length) + '.jsx';
        if (!src.endsWith('.js') && !src.endsWith('.jsx'))
            src = src + '.js';
        codeGen.addText(`export * from `);
        codeGen.addCode(`'${src}'`, { start: -1, end: -1 }, SourceMaps.Mode.Offset, {
            vueTag: 'scriptSrc',
            capabilities: {
                basic: true,
                references: true,
                definitions: true,
                rename: true,
                diagnostic: true,
                completion: true,
                semanticTokens: true,
            },
        });
        codeGen.addText(`;\n`);
        codeGen.addText(`export { default } from '${src}';\n`);
    }
    function writeScriptContentBeforeExportDefault() {
        if (!sfc.script)
            return;
        if (!!sfc.scriptSetup && (scriptRanges === null || scriptRanges === void 0 ? void 0 : scriptRanges.exportDefault)) {
            addVirtualCode('script', 0, scriptRanges.exportDefault.expression.start);
            exportdefaultStart = codeGen.getText().length - (scriptRanges.exportDefault.expression.start - scriptRanges.exportDefault.start);
        }
        else {
            let isExportRawObject = false;
            if (scriptRanges === null || scriptRanges === void 0 ? void 0 : scriptRanges.exportDefault) {
                isExportRawObject = sfc.script.content.substring(scriptRanges.exportDefault.expression.start, scriptRanges.exportDefault.expression.end).startsWith('{');
            }
            const warpperEnabled = vueCompilerOptions.experimentalComponentOptionsWrapperEnable === true
                || (vueCompilerOptions.experimentalComponentOptionsWrapperEnable === 'onlyJs' && (lang === 'js' || lang === 'jsx'));
            if (isExportRawObject && warpperEnabled && (scriptRanges === null || scriptRanges === void 0 ? void 0 : scriptRanges.exportDefault)) {
                addVirtualCode('script', 0, scriptRanges.exportDefault.expression.start);
                codeGen.addText(vueCompilerOptions.experimentalComponentOptionsWrapper[0]);
                addVirtualCode('script', scriptRanges.exportDefault.expression.start, scriptRanges.exportDefault.expression.end);
                codeGen.addText(vueCompilerOptions.experimentalComponentOptionsWrapper[1]);
                addVirtualCode('script', scriptRanges.exportDefault.expression.end, sfc.script.content.length);
            }
            else {
                addVirtualCode('script', 0, sfc.script.content.length);
            }
        }
    }
    function writeScriptContentAfterExportDefault() {
        if (!sfc.script)
            return;
        if (!!sfc.scriptSetup && (scriptRanges === null || scriptRanges === void 0 ? void 0 : scriptRanges.exportDefault)) {
            addVirtualCode('script', scriptRanges.exportDefault.end, sfc.script.content.length);
        }
    }
    function addVirtualCode(vueTag, start, end) {
        codeGen.addCode2((vueTag === 'script' ? sfc.script : sfc.scriptSetup).content.substring(start, end), start, {
            vueTag: vueTag,
            capabilities: {
                basic: true,
                references: true,
                definitions: true,
                rename: true,
                diagnostic: true,
                completion: true,
                semanticTokens: true,
            },
        });
    }
    function addExtraReferenceVirtualCode(vueTag, start, end) {
        codeGen.addCode2((vueTag === 'scriptSetup' ? sfc.scriptSetup : sfc.script).content.substring(start, end), start, {
            vueTag,
            capabilities: {
                references: true,
                definitions: true,
                rename: true,
            },
        });
    }
    function writeScriptSetupImportsSegment() {
        if (!sfc.scriptSetup)
            return;
        if (!scriptSetupRanges)
            return;
        codeGen.addCode2(sfc.scriptSetup.content.substring(0, scriptSetupRanges.importSectionEndOffset), 0, {
            vueTag: 'scriptSetup',
            capabilities: {
                basic: true,
                references: true,
                definitions: true,
                diagnostic: true,
                rename: true,
                completion: true,
                semanticTokens: true,
            },
        });
    }
    function writeTemplateIfNoScriptSetup() {
        if (!sfc.scriptSetup) {
            writeTemplate();
        }
    }
    function writeScriptSetupAndTemplate() {
        var _a;
        if (sfc.scriptSetup && scriptSetupRanges) {
            if (scriptRanges === null || scriptRanges === void 0 ? void 0 : scriptRanges.exportDefault) {
                codeGen.addText('await (async () => {\n');
            }
            else {
                exportdefaultStart = codeGen.getText().length;
                codeGen.addText('export default await (async () => {\n');
            }
            codeGen.addText('const __VLS_setup = async () => {\n');
            codeGen.addCode2(sfc.scriptSetup.content.substring(scriptSetupRanges.importSectionEndOffset), scriptSetupRanges.importSectionEndOffset, {
                vueTag: 'scriptSetup',
                capabilities: {
                    basic: true,
                    references: true,
                    definitions: true,
                    diagnostic: true,
                    rename: true,
                    completion: true,
                    semanticTokens: true,
                },
            });
            if (scriptSetupRanges.propsTypeArg && scriptSetupRanges.withDefaultsArg) {
                // fix https://github.com/johnsoncodehk/volar/issues/1187
                codeGen.addText(`const __VLS_withDefaultsArg = (function <T>(t: T) { return t })(`);
                addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.withDefaultsArg.start, scriptSetupRanges.withDefaultsArg.end);
                codeGen.addText(`);\n`);
            }
            if ((scriptRanges === null || scriptRanges === void 0 ? void 0 : scriptRanges.exportDefault) && scriptRanges.exportDefault.expression.start !== scriptRanges.exportDefault.args.start) {
                // use defineComponent() from user space code if it exist
                codeGen.addText(`const __VLS_Component = `);
                addVirtualCode('script', scriptRanges.exportDefault.expression.start, scriptRanges.exportDefault.args.start);
                codeGen.addText(`{\n`);
            }
            else {
                codeGen.addText(`const __VLS_Component = (await import('${vueLibName}')).defineComponent({\n`);
            }
            if (!downgradePropsAndEmitsToSetupReturnOnScriptSetup) {
                if (scriptSetupRanges.propsRuntimeArg || scriptSetupRanges.propsTypeArg) {
                    codeGen.addText(`props: (`);
                    if (scriptSetupRanges.propsTypeArg) {
                        usedTypes.DefinePropsToOptions = true;
                        codeGen.addText(`{} as `);
                        if (scriptSetupRanges.withDefaultsArg) {
                            usedTypes.mergePropDefaults = true;
                            codeGen.addText(`__VLS_WithDefaults<`);
                        }
                        codeGen.addText(`__VLS_TypePropsToRuntimeProps<`);
                        addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.propsTypeArg.start, scriptSetupRanges.propsTypeArg.end);
                        codeGen.addText(`>`);
                        if (scriptSetupRanges.withDefaultsArg) {
                            codeGen.addText(`, typeof __VLS_withDefaultsArg`);
                            codeGen.addText(`>`);
                        }
                    }
                    else if (scriptSetupRanges.propsRuntimeArg) {
                        addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.propsRuntimeArg.start, scriptSetupRanges.propsRuntimeArg.end);
                    }
                    codeGen.addText(`),\n`);
                }
                if (scriptSetupRanges.emitsTypeArg) {
                    usedTypes.ConstructorOverloads = true;
                    codeGen.addText(`emits: ({} as __VLS_UnionToIntersection<__VLS_ConstructorOverloads<`);
                    addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.emitsTypeArg.start, scriptSetupRanges.emitsTypeArg.end);
                    codeGen.addText(`>>),\n`);
                }
                else if (scriptSetupRanges.emitsRuntimeArg) {
                    codeGen.addText(`emits: (`);
                    addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.emitsRuntimeArg.start, scriptSetupRanges.emitsRuntimeArg.end);
                    codeGen.addText(`),\n`);
                }
            }
            codeGen.addText(`setup() {\n`);
            codeGen.addText(`return {\n`);
            if (downgradePropsAndEmitsToSetupReturnOnScriptSetup) {
                // fill $props
                if (scriptSetupRanges.propsTypeArg) {
                    // NOTE: defineProps is inaccurate for $props
                    codeGen.addText(`$props: (await import('./__VLS_types.js')).makeOptional(defineProps<`);
                    addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.propsTypeArg.start, scriptSetupRanges.propsTypeArg.end);
                    codeGen.addText(`>()),\n`);
                }
                else if (scriptSetupRanges.propsRuntimeArg) {
                    // NOTE: defineProps is inaccurate for $props
                    codeGen.addText(`$props: (await import('./__VLS_types.js')).makeOptional(defineProps(`);
                    addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.propsRuntimeArg.start, scriptSetupRanges.propsRuntimeArg.end);
                    codeGen.addText(`)),\n`);
                }
                // fill $emit
                if (scriptSetupRanges.emitsAssignName) {
                    codeGen.addText(`$emit: ${scriptSetupRanges.emitsAssignName},\n`);
                }
                else if (scriptSetupRanges.emitsTypeArg) {
                    codeGen.addText(`$emit: defineEmits<`);
                    addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.emitsTypeArg.start, scriptSetupRanges.emitsTypeArg.end);
                    codeGen.addText(`>(),\n`);
                }
                else if (scriptSetupRanges.emitsRuntimeArg) {
                    codeGen.addText(`$emit: defineEmits(`);
                    addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.emitsRuntimeArg.start, scriptSetupRanges.emitsRuntimeArg.end);
                    codeGen.addText(`),\n`);
                }
            }
            if (scriptSetupRanges.exposeTypeArg) {
                codeGen.addText(`...({} as `);
                addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.exposeTypeArg.start, scriptSetupRanges.exposeTypeArg.end);
                codeGen.addText(`),\n`);
            }
            else if (scriptSetupRanges.exposeRuntimeArg) {
                codeGen.addText(`...(`);
                addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.exposeRuntimeArg.start, scriptSetupRanges.exposeRuntimeArg.end);
                codeGen.addText(`),\n`);
            }
            codeGen.addText(`};\n`);
            codeGen.addText(`},\n`);
            if (sfc.script && ((_a = scriptRanges === null || scriptRanges === void 0 ? void 0 : scriptRanges.exportDefault) === null || _a === void 0 ? void 0 : _a.args)) {
                addVirtualCode('script', scriptRanges.exportDefault.args.start + 1, scriptRanges.exportDefault.args.end - 1);
            }
            codeGen.addText(`});\n`);
            writeTemplate();
            if (htmlGen === null || htmlGen === void 0 ? void 0 : htmlGen.slotsNum) {
                codeGen.addText(`return {} as typeof __VLS_Component & (new () => { ${(0, shared_2.getSlotsPropertyName)(vueVersion)}: ReturnType<typeof __VLS_template> });\n`);
            }
            else {
                codeGen.addText(`return {} as typeof __VLS_Component;\n`);
            }
            codeGen.addText(`};\n`);
            codeGen.addText(`return await __VLS_setup();\n`);
            codeGen.addText(`})();`);
            exportdefaultEnd = codeGen.getText().length;
            codeGen.addText(`\n`);
        }
    }
    function writeTemplate() {
        if (lang === 'jsx' || lang === 'tsx') {
            writeExportOptions();
            writeConstNameOption();
            codeGen.addText(`function __VLS_template() {\n`);
            codeGen.addText(`import * as __VLS_types from './__VLS_types.js'; import('./__VLS_types.js');\n`);
            const templateGened = writeTemplateContext();
            codeGen.addText(`}\n`);
            writeComponentForTemplateUsage(templateGened.cssIds);
        }
        else {
            codeGen.addText(`function __VLS_template() {\n`);
            const templateUsageVars = [...getTemplateUsageVars()];
            codeGen.addText(`// @ts-ignore\n`);
            codeGen.addText(`[${templateUsageVars.join(', ')}]\n`);
            codeGen.addText(`return {};\n`);
            codeGen.addText(`}\n`);
        }
    }
    function writeComponentForTemplateUsage(cssIds) {
        if (sfc.scriptSetup && scriptSetupRanges) {
            codeGen.addText(`const __VLS_component = (await import('${vueLibName}')).defineComponent({\n`);
            codeGen.addText(`setup() {\n`);
            codeGen.addText(`return {\n`);
            // fill ctx from props
            if (downgradePropsAndEmitsToSetupReturnOnScriptSetup) {
                if (scriptSetupRanges.propsAssignName) {
                    codeGen.addText(`...${scriptSetupRanges.propsAssignName},\n`);
                }
                else if (scriptSetupRanges.withDefaultsArg && scriptSetupRanges.propsTypeArg) {
                    codeGen.addText(`...withDefaults(defineProps<`);
                    addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.propsTypeArg.start, scriptSetupRanges.propsTypeArg.end);
                    codeGen.addText(`>(), `);
                    addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.withDefaultsArg.start, scriptSetupRanges.withDefaultsArg.end);
                    codeGen.addText(`),\n`);
                }
                else if (scriptSetupRanges.propsRuntimeArg) {
                    codeGen.addText(`...defineProps(`);
                    addExtraReferenceVirtualCode('scriptSetup', scriptSetupRanges.propsRuntimeArg.start, scriptSetupRanges.propsRuntimeArg.end);
                    codeGen.addText(`),\n`);
                }
            }
            // bindings
            const bindingsArr = [];
            bindingsArr.push({
                bindings: scriptSetupRanges.bindings,
                content: sfc.scriptSetup.content,
                vueTag: 'scriptSetup',
            });
            if (scriptRanges && sfc.script) {
                bindingsArr.push({
                    bindings: scriptRanges.bindings,
                    content: sfc.script.content,
                    vueTag: 'script',
                });
            }
            const templateUsageVars = getTemplateUsageVars();
            for (const { bindings, content } of bindingsArr) {
                for (const expose of bindings) {
                    const varName = content.substring(expose.start, expose.end);
                    if (!templateUsageVars.has(varName) && !cssIds.has(varName)) {
                        continue;
                    }
                    const templateSideRange = codeGen.addText(varName);
                    codeGen.addText(`: `);
                    const scriptSideRange = codeGen.addText(varName);
                    codeGen.addText(',\n');
                    teleports.push({
                        sourceRange: scriptSideRange,
                        mappedRange: templateSideRange,
                        mode: SourceMaps.Mode.Offset,
                        data: {
                            toSource: {
                                capabilities: {
                                    definitions: true,
                                    references: true,
                                    rename: true,
                                },
                            },
                            toTarget: {
                                capabilities: {
                                    definitions: true,
                                    references: true,
                                    rename: true,
                                },
                            },
                        },
                    });
                }
            }
            codeGen.addText(`};\n`); // return {
            codeGen.addText(`},\n`); // setup() {
            codeGen.addText(`});\n`); // defineComponent({
        }
        else if (sfc.script) {
            codeGen.addText(`let __VLS_component!: typeof import('./${path_1.posix.basename(fileName)}')['default'];\n`);
        }
        else {
            codeGen.addText(`const __VLS_component = (await import('${vueLibName}')).defineComponent({});\n`);
        }
    }
    function writeExportOptions() {
        var _a;
        codeGen.addText(`\n`);
        codeGen.addText(`const __VLS_options = {\n`);
        if (sfc.script && ((_a = scriptRanges === null || scriptRanges === void 0 ? void 0 : scriptRanges.exportDefault) === null || _a === void 0 ? void 0 : _a.args)) {
            const args = scriptRanges.exportDefault.args;
            codeGen.addText(`...(`);
            codeGen.addCode2(sfc.script.content.substring(args.start, args.end), args.start, {
                vueTag: 'script',
                capabilities: {
                    references: true,
                    rename: true,
                },
            });
            codeGen.addText(`),\n`);
        }
        codeGen.addText(`};\n`);
    }
    function writeConstNameOption() {
        var _a;
        codeGen.addText(`\n`);
        if (sfc.script && ((_a = scriptRanges === null || scriptRanges === void 0 ? void 0 : scriptRanges.exportDefault) === null || _a === void 0 ? void 0 : _a.args)) {
            const args = scriptRanges.exportDefault.args;
            codeGen.addText(`const __VLS_name = (await import('./__VLS_types.js')).getNameOption(`);
            codeGen.addText(`${sfc.script.content.substring(args.start, args.end)} as const`);
            codeGen.addText(`);\n`);
        }
        else if (sfc.scriptSetup) {
            codeGen.addText(`let __VLS_name!: '${path_1.posix.basename(fileName.substring(0, fileName.lastIndexOf('.')))}';\n`);
        }
        else {
            codeGen.addText(`const __VLS_name = undefined;\n`);
        }
    }
    function writeTemplateContext() {
        var _a;
        const useGlobalThisTypeInCtx = fileName.endsWith('.html');
        codeGen.addText(`let __VLS_ctx!: ${useGlobalThisTypeInCtx ? 'typeof globalThis &' : ''}`);
        codeGen.addText(`__VLS_types.PickNotAny<__VLS_Ctx, {}> & `);
        if (sfc.scriptSetup) {
            codeGen.addText(`InstanceType<__VLS_types.PickNotAny<typeof __VLS_Component, new () => {}>> & `);
        }
        codeGen.addText(`InstanceType<__VLS_types.PickNotAny<typeof __VLS_component, new () => {}>> & {\n`);
        /* CSS Module */
        for (const cssModule of cssModuleClasses) {
            codeGen.addText(`${cssModule.style.module}: Record<string, string>`);
            for (const classNameRange of cssModule.classNameRanges) {
                writeCssClassProperty(cssModule.index, cssModule.style.content.substring(classNameRange.start + 1, classNameRange.end), classNameRange, 'string', false);
            }
            codeGen.addText(';\n');
        }
        codeGen.addText(`};\n`);
        codeGen.addText(`let __VLS_vmUnwrap!: typeof __VLS_options & { components: { } };\n`);
        /* Components */
        codeGen.addText('/* Components */\n');
        codeGen.addText('let __VLS_otherComponents!: NonNullable<typeof __VLS_component extends { components: infer C } ? C : {}> & __VLS_types.GlobalComponents & typeof __VLS_vmUnwrap.components & __VLS_types.PickComponents<typeof __VLS_ctx>;\n');
        codeGen.addText(`let __VLS_selfComponent!: __VLS_types.SelfComponent<typeof __VLS_name, typeof __VLS_component & (new () => { ${(0, shared_2.getSlotsPropertyName)((_a = vueCompilerOptions.target) !== null && _a !== void 0 ? _a : 3)}: typeof __VLS_slots })>;\n`);
        codeGen.addText('let __VLS_components!: typeof __VLS_otherComponents & Omit<typeof __VLS_selfComponent, keyof typeof __VLS_otherComponents>;\n');
        codeGen.addText(`__VLS_components['${string_1.SearchTexts.Components}'];\n`);
        codeGen.addText(`({} as __VLS_types.GlobalAttrs)['${string_1.SearchTexts.GlobalAttrs}'];\n`);
        /* Style Scoped */
        codeGen.addText('/* Style Scoped */\n');
        codeGen.addText('type __VLS_StyleScopedClasses = {}');
        for (const scopedCss of cssScopedClasses) {
            for (const classNameRange of scopedCss.classNameRanges) {
                writeCssClassProperty(scopedCss.index, scopedCss.style.content.substring(classNameRange.start + 1, classNameRange.end), classNameRange, 'boolean', true);
            }
        }
        codeGen.addText(';\n');
        codeGen.addText('let __VLS_styleScopedClasses!: __VLS_StyleScopedClasses | keyof __VLS_StyleScopedClasses | (keyof __VLS_StyleScopedClasses)[];\n');
        codeGen.addText(`/* CSS variable injection */\n`);
        const cssIds = writeCssVars();
        codeGen.addText(`/* CSS variable injection end */\n`);
        if (htmlGen) {
            (0, code_gen_1.mergeCodeGen)(codeGen, htmlGen.codeGen);
        }
        if (!htmlGen) {
            codeGen.addText(`const __VLS_slots = {};\n`);
        }
        codeGen.addText(`return __VLS_slots;\n`);
        return { cssIds };
        function writeCssClassProperty(styleIndex, className, classRange, propertyType, optional) {
            codeGen.addText(`\n & { `);
            codeGen.addMapping2({
                mappedRange: {
                    start: codeGen.getText().length,
                    end: codeGen.getText().length + className.length + 2,
                },
                sourceRange: classRange,
                mode: SourceMaps.Mode.Totally,
                additional: [{
                        mappedRange: {
                            start: codeGen.getText().length + 1,
                            end: codeGen.getText().length + 1 + className.length,
                        },
                        sourceRange: classRange,
                        mode: SourceMaps.Mode.Offset,
                    }],
                data: {
                    vueTag: 'style',
                    vueTagIndex: styleIndex,
                    capabilities: {
                        references: true,
                        rename: true,
                        referencesCodeLens: true,
                    },
                    normalizeNewName: beforeCssRename,
                    applyNewName: doCssRename,
                },
            });
            codeGen.addText(`'${className}'${optional ? '?' : ''}: ${propertyType}`);
            codeGen.addText(` }`);
        }
        function writeCssVars() {
            const emptyLocalVars = {};
            const identifiers = new Set();
            for (const cssVar of cssVars) {
                for (const cssBind of cssVar.ranges) {
                    const code = cssVar.style.content.substring(cssBind.start, cssBind.end);
                    (0, transform_1.walkInterpolationFragment)(ts, code, ts.createSourceFile('/a.txt', code, ts.ScriptTarget.ESNext), (frag, fragOffset, isJustForErrorMapping) => {
                        if (fragOffset === undefined) {
                            codeGen.addText(frag);
                        }
                        else {
                            codeGen.addCode2(frag, cssBind.start + fragOffset, {
                                vueTag: 'style',
                                vueTagIndex: cssVar.styleIndex,
                                capabilities: isJustForErrorMapping ? {
                                    diagnostic: true,
                                } : {
                                    basic: true,
                                    references: true,
                                    definitions: true,
                                    diagnostic: true,
                                    rename: true,
                                    completion: true,
                                    semanticTokens: true,
                                },
                            });
                        }
                    }, emptyLocalVars, identifiers);
                    codeGen.addText(';\n');
                }
            }
            return identifiers;
        }
    }
    function getTemplateUsageVars() {
        const usageVars = new Set();
        if (htmlGen) {
            let bindingNames = [];
            if (scriptSetupRanges) {
                bindingNames = bindingNames.concat(scriptSetupRanges.bindings.map(range => { var _a, _b; return (_b = (_a = sfc.scriptSetup) === null || _a === void 0 ? void 0 : _a.content.substring(range.start, range.end)) !== null && _b !== void 0 ? _b : ''; }));
            }
            if (scriptRanges) {
                bindingNames = bindingNames.concat(scriptRanges.bindings.map(range => { var _a, _b; return (_b = (_a = sfc.script) === null || _a === void 0 ? void 0 : _a.content.substring(range.start, range.end)) !== null && _b !== void 0 ? _b : ''; }));
            }
            // fix import components unused report
            for (const varName of bindingNames) {
                if (!!htmlGen.tagNames[varName] || !!htmlGen.tagNames[(0, shared_1.hyphenate)(varName)]) {
                    usageVars.add(varName);
                }
            }
            for (const tag of Object.keys(htmlGen.tagNames)) {
                if (tag.indexOf('.') >= 0) {
                    usageVars.add(tag);
                }
            }
            for (const _id of htmlGen.identifiers) {
                usageVars.add(_id);
            }
        }
        return usageVars;
    }
}
exports.generate = generate;
// TODO: not working for overloads > n (n = 8)
// see: https://github.com/johnsoncodehk/volar/issues/60
function genConstructorOverloads(name = 'ConstructorOverloads', nums) {
    let code = `type ${name}<T> =\n`;
    if (nums === undefined) {
        for (let i = 8; i >= 1; i--) {
            gen(i);
        }
    }
    else {
        gen(nums);
    }
    code += `// 0\n`;
    code += `{};\n`;
    return code;
    function gen(i) {
        code += `// ${i}\n`;
        code += `T extends {\n`;
        for (let j = 1; j <= i; j++) {
            code += `(event: infer E${j}, ...payload: infer P${j}): void;\n`;
        }
        code += `} ? (\n`;
        for (let j = 1; j <= i; j++) {
            if (j > 1)
                code += '& ';
            code += `(E${j} extends string ? { [K${j} in E${j}]: (...payload: P${j}) => void } : {})\n`;
        }
        code += `) :\n`;
    }
}
function beforeCssRename(newName) {
    return newName.startsWith('.') ? newName.slice(1) : newName;
}
function doCssRename(oldName, newName) {
    return '.' + newName;
}
//# sourceMappingURL=script.js.map